/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.interceptor;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BasePathMatchInterceptor;
import io.github.novareseller.security.helper.ClientAuthorizationHelper;
import io.github.novareseller.tool.utils.SystemClock;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClientSignInterceptor
extends BasePathMatchInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClientSignInterceptor.class);
    private String clientId;
    private String clientSecret;

    protected Response doIntercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestBody requestBody = request.body();
        String authorization = "";
        long ts = SystemClock.now();
        try {
            if (requestBody != null) {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                byte[] data = buffer.readByteArray();
                authorization = ClientAuthorizationHelper.createAuthorization((long)ts, (String)this.clientId, (String)this.clientSecret, (byte[])data);
            } else {
                authorization = ClientAuthorizationHelper.createAuthorization((long)ts, (String)this.clientId, (String)this.clientSecret, (byte[])new byte[0]);
            }
        }
        catch (Exception e) {
            log.error("Client Sign Exception, ex={}", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
        }
        Request newReq = request.newBuilder().addHeader("X-Client-Authorization", authorization).build();
        return chain.proceed(newReq);
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }
}

