/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.interceptor;

import io.github.novareseller.boot.utils.HttpUtils;
import io.github.novareseller.log.handler.LogHandler;
import io.github.novareseller.log.handler.LogLabelBean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpLogHandler
extends LogHandler {
    private static volatile HttpLogHandler httpLogHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpLogHandler loadInstance() {
        if (httpLogHandler != null) return httpLogHandler;
        Class<HttpLogHandler> clazz = HttpLogHandler.class;
        synchronized (HttpLogHandler.class) {
            if (httpLogHandler != null) return httpLogHandler;
            httpLogHandler = new HttpLogHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpLogHandler;
        }
    }

    public void preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String traceId = request.getHeader("Trace-Id");
        String spanId = request.getHeader("Span-Id");
        String preIvkApp = request.getHeader("Pre-Ivk-App");
        String preIvkHost = request.getHeader("Pre-Ivk-Host");
        String preIp = HttpUtils.getRemoteHost(request);
        LogLabelBean labelBean = new LogLabelBean(preIvkApp, preIvkHost, preIp, traceId, spanId);
        this.processProviderSide(labelBean);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler) {
        this.cleanThreadLocal();
    }
}

