/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.interceptor;

import io.github.novareseller.boot.interceptor.AbsWebHandlerMethodInterceptor;
import io.github.novareseller.boot.utils.HttpUtils;
import io.github.novareseller.boot.utils.JsonUtils;
import io.github.novareseller.boot.utils.ResponseUtils;
import io.github.novareseller.boot.utils.SpringUtils;
import io.github.novareseller.boot.wrapper.ApiResponse;
import io.github.novareseller.boot.wrapper.MultipleReadHttpRequestWrapper;
import io.github.novareseller.database.base.TenantContextHolder;
import io.github.novareseller.security.annotation.VerifyTenant;
import io.github.novareseller.security.helper.ClientAuthorizationHelper;
import io.github.novareseller.security.model.TenantInfo;
import io.github.novareseller.security.spi.TenantInfoHolder;
import io.github.novareseller.tool.utils.Validator;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

public class TenantAuthInterceptor
extends AbsWebHandlerMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TenantAuthInterceptor.class);

    @Override
    public boolean preHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long tenantId;
        long timestamp;
        if (!this.hasVerifyTenantAnnotation((HandlerMethod)handler)) {
            return true;
        }
        String host = HttpUtils.getRemoteHost(request);
        String region = HttpUtils.getClientRegion(request);
        String uri = request.getRequestURI();
        String method = request.getMethod();
        byte[] data = this.readRequestData(request);
        String authorization = request.getHeader("X-Tenant-Authorization");
        if (Validator.isNullOrEmpty((Object)authorization)) {
            log.error("Authorization required: uri={}, host={}", (Object)uri, (Object)host);
            this.responseError(response, "Authorization required.");
            return false;
        }
        String[] ss = authorization.split(";");
        if (ss.length != 4) {
            log.error("Invalid authorization: uri={}, host={}, authorization={}", new Object[]{uri, host, authorization});
            this.responseError(response, "Invalid authorization format");
            return false;
        }
        try {
            timestamp = Long.parseLong(ss[1]);
            tenantId = Integer.parseInt(ss[2]);
        }
        catch (Exception ex) {
            log.error("Invalid authorization format: uri={}, host={}, authorization={}, timestamp={}, tenantId={}", new Object[]{uri, host, authorization, ss[1], ss[2]});
            this.responseError(response, "Invalid authorization format");
            return false;
        }
        TenantInfoHolder holder = SpringUtils.getBean(TenantInfoHolder.class);
        TenantInfo tenantInfo = holder.findTenantInfo(Long.valueOf(tenantId));
        if (tenantInfo == null) {
            log.error("Invalid tenantId: uri={}, host={}, authorization={}, tenantId={}", new Object[]{uri, host, authorization, tenantId});
            this.responseError(response, "Invalid tenantId");
            return false;
        }
        if (System.currentTimeMillis() - timestamp > 300000L) {
            log.error("Authorization expired: uri={}, host={}, authorization={}", new Object[]{uri, host, authorization});
            this.responseError(response, "Authorization expired");
            return false;
        }
        boolean success = ClientAuthorizationHelper.verifyAuthorization((String)String.valueOf(tenantId), (String)tenantInfo.getSecretKey(), (byte[])data, (String)authorization);
        if (!success) {
            log.error("Authorization failed: uri={}, host={}, authorization={}", new Object[]{uri, host, authorization});
            this.responseError(response, "Invalid authorization");
            return false;
        }
        request.setAttribute("tenantId", (Object)tenantInfo.getId());
        TenantContextHolder.setTenant((Long)tenantInfo.getId());
        String id = String.format("%08x", request.hashCode());
        log.info("API request[{}]: method={}, uri={}, host={}, region={}, authorization={}, content-length={}", new Object[]{id, method, uri, host, region, authorization, data.length});
        return true;
    }

    @Override
    public void postHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletionByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.hasVerifyTenantAnnotation((HandlerMethod)handler) && request instanceof MultipleReadHttpRequestWrapper) {
            String id = String.format("%08x", request.hashCode());
            log.info("API completed[{}]: status={}, contentType={}", new Object[]{id, response.getStatus(), response.getContentType()});
        }
        TenantContextHolder.clear();
    }

    private boolean hasVerifyTenantAnnotation(HandlerMethod handlerMethod) {
        VerifyTenant annotation = handlerMethod.getBeanType().getAnnotation(VerifyTenant.class);
        if (annotation == null) {
            annotation = (VerifyTenant)handlerMethod.getMethodAnnotation(VerifyTenant.class);
        }
        return annotation != null;
    }

    private void responseError(HttpServletResponse response, String message) throws Exception {
        ApiResponse error = ResponseUtils.error(-24031, message);
        String json = JsonUtils.json(error);
        byte[] data = json.getBytes(StandardCharsets.UTF_8);
        response.setStatus(401);
        response.setContentType("application/json;charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }
}

