/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.interceptor;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BasePathMatchInterceptor;
import io.github.novareseller.boot.utils.SpringUtils;
import io.github.novareseller.security.helper.ClientAuthorizationHelper;
import io.github.novareseller.security.model.TenantInfo;
import io.github.novareseller.security.spi.TenantInfoHolder;
import io.github.novareseller.tool.utils.SystemClock;
import io.github.novareseller.tool.utils.Validator;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TenantSignInterceptor
extends BasePathMatchInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TenantSignInterceptor.class);
    private static final String TENANT_HEADER = "tenantId";

    protected Response doIntercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        TenantInfoHolder holder = SpringUtils.getBean(TenantInfoHolder.class);
        String tenantId = request.header(TENANT_HEADER);
        if (Validator.isNullOrEmpty((Object)tenantId)) {
            throw new RuntimeException("tenantId parameter is missing in header");
        }
        TenantInfo tenantInfo = holder.findTenantInfo(Long.valueOf(Long.parseLong(tenantId)));
        RequestBody requestBody = request.body();
        String authorization = "";
        long ts = SystemClock.now();
        try {
            if (requestBody != null) {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                byte[] data = buffer.readByteArray();
                authorization = ClientAuthorizationHelper.createAuthorization((long)ts, (String)String.valueOf(tenantInfo.getId()), (String)tenantInfo.getSecretKey(), (byte[])data);
            } else {
                authorization = ClientAuthorizationHelper.createAuthorization((long)ts, (String)String.valueOf(tenantInfo.getId()), (String)tenantInfo.getSecretKey(), (byte[])new byte[0]);
            }
        }
        catch (Exception e) {
            log.error("Client Sign Exception, ex={}", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
        }
        Request newReq = request.newBuilder().addHeader("X-Tenant-Authorization", authorization).build();
        return chain.proceed(newReq);
    }
}

