/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.interceptor;

import io.github.novareseller.boot.exception.ApiException;
import io.github.novareseller.boot.interceptor.AbsWebHandlerMethodInterceptor;
import io.github.novareseller.boot.utils.HttpUtils;
import io.github.novareseller.boot.utils.SpringUtils;
import io.github.novareseller.security.annotation.VerifyUser;
import io.github.novareseller.security.config.TenantJwtBuilder;
import io.github.novareseller.security.context.LoginUser;
import io.github.novareseller.security.context.SecurityContext;
import io.github.novareseller.tool.utils.Validator;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

public class UserAuthInterceptor
extends AbsWebHandlerMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UserAuthInterceptor.class);
    private static final AntPathMatcher MATCHER = new AntPathMatcher();
    private List<String> excludePathPatterns;

    public UserAuthInterceptor(List<String> excludePathPatterns) {
        this.excludePathPatterns = excludePathPatterns;
    }

    @Override
    public boolean preHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.hasVerifyUserAnnotation((HandlerMethod)handler)) {
            return true;
        }
        String authorization = request.getHeader("Authorization");
        String authorizationHash = StringUtils.isBlank((CharSequence)authorization) ? null : String.format("%08x", authorization.hashCode());
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String ip = HttpUtils.getRemoteHost(request);
        String language = this.getLanguage(request);
        if (this.isExcludePath(uri)) {
            log.info("http request:token hash={}, user={}", (Object)authorizationHash, (Object)"Anonymous user ignoring token");
            return true;
        }
        this.authentication(authorization, uri, method, ip, language);
        log.info("http request:token hash={}, user={}, method={}, uri={}, ip={}, language={}", new Object[]{authorizationHash, SecurityContext.getLoginUser(), method, uri, ip, language});
        return true;
    }

    @Override
    public void postHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletionByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        SecurityContext.clear();
    }

    private void authentication(String authorization, String uri, String method, String ip, String language) throws Exception {
        if (null == authorization || "null".equals(authorization) || "".equals(authorization)) {
            log.warn("login token is required. uri={}, method={}", (Object)uri, (Object)method);
            throw new ApiException(-24010, "Login token is required");
        }
        try {
            TenantJwtBuilder tenantJwtBuilder = SpringUtils.getBean(TenantJwtBuilder.class);
            Claims claims = tenantJwtBuilder.parseTokenClaims(authorization);
            LoginUser loginUser = LoginUser.claims2LoginUser((Claims)claims);
            loginUser.setClientIp(ip);
            loginUser.setLanguage(language);
            loginUser.setToken(authorization);
            SecurityContext.setLoginUser((LoginUser)loginUser);
        }
        catch (ExpiredJwtException ex) {
            log.error("token expired. login token={},uri={},method={}", new Object[]{authorization, uri, method, ex});
            throw new ApiException(-24020, "token has expired");
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException ex) {
            log.error("token decode error. login token={},uri={},method={}", new Object[]{authorization, uri, method, ex});
            throw new ApiException(-24030, "token error");
        }
    }

    private boolean hasVerifyUserAnnotation(HandlerMethod handlerMethod) {
        VerifyUser annotation = handlerMethod.getBeanType().getAnnotation(VerifyUser.class);
        if (annotation == null) {
            annotation = (VerifyUser)handlerMethod.getMethodAnnotation(VerifyUser.class);
        }
        return annotation != null;
    }

    private boolean isExcludePath(String uri) {
        if (!Validator.isNullOrEmpty(this.excludePathPatterns)) {
            for (String excludePathPattern : this.excludePathPatterns) {
                if (!MATCHER.match(excludePathPattern, uri)) continue;
                return true;
            }
        }
        return false;
    }
}

