/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.wrapper;

import com.google.common.collect.Iterables;
import io.github.novareseller.tool.utils.RandomUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;

public class MultipleReadHttpRequestWrapper
extends HttpServletRequestWrapper {
    private ByteArrayOutputStream cached = null;
    private Map<String, String[]> parameterMap;
    private final String id = RandomUtil.getLocalString((int)12, (int)1);

    public MultipleReadHttpRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            LinkedHashMap<String, Set<String>> map = new LinkedHashMap<String, Set<String>>();
            this.decode(this.getQueryString(), map);
            this.decode(this.getPostBodyAsString(), map);
            LinkedHashMap result = new LinkedHashMap();
            map.forEach((key, values) -> {
                ArrayList al = new ArrayList(values);
                String[] a = al.toArray(new String[values.size()]);
                result.put(key, a);
            });
            this.parameterMap = Collections.unmodifiableMap(result);
        }
        return this.parameterMap;
    }

    public String getParameter(String key) {
        Map<String, String[]> parameterMap = this.getParameterMap();
        String[] values = parameterMap.get(key);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public String[] getParameterValues(String key) {
        Map<String, String[]> parameterMap = this.getParameterMap();
        return parameterMap.get(key);
    }

    private String getPostBodyAsString() {
        try {
            if (this.cached == null) {
                this.cacheInputStream();
            }
            return this.cached.toString(this.getCharacterEncoding());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void fillMap(Iterable<NameValuePair> params, Map<String, Set<String>> map) {
        for (NameValuePair pair : params) {
            Set<Object> values;
            String key = pair.getName();
            String value = pair.getValue();
            if (map.containsKey(key)) {
                values = map.get(key);
                values.add(value);
                continue;
            }
            values = new LinkedHashSet();
            values.add(value);
            map.put(key, values);
        }
    }

    private Iterable<NameValuePair> decodeParams(String body) {
        Iterable params = URLEncodedUtils.parse((String)body, (Charset)StandardCharsets.UTF_8);
        try {
            ContentType ct;
            String cts = this.getContentType();
            if (cts != null && (ct = ContentType.parse((String)cts)).getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                List postParams = URLEncodedUtils.parse((String)IOUtils.toString((Reader)this.getReader()), (Charset)StandardCharsets.UTF_8);
                params = Iterables.concat((Iterable)params, (Iterable)postParams);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return params;
    }

    private void decode(String query, Map<String, Set<String>> map) {
        if (query != null) {
            MultipleReadHttpRequestWrapper.fillMap(this.decodeParams(query), map);
        }
    }

    public String getCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    private void cacheInputStream() throws IOException {
        this.cached = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)super.getInputStream(), (OutputStream)this.cached);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.cached == null) {
            this.cacheInputStream();
        }
        return new MultipleReadInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), StandardCharsets.UTF_8));
    }

    private class MultipleReadInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream input;

        MultipleReadInputStream() {
            this.input = new ByteArrayInputStream(MultipleReadHttpRequestWrapper.this.cached.toByteArray());
        }

        public boolean isFinished() {
            return this.input.available() > 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.input.read();
        }

        public synchronized void reset() throws IOException {
            this.input.reset();
        }
    }
}

