/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.autoconfigure;

import io.github.novareseller.cache.properties.J2CacheProperties;
import io.github.novareseller.cache.support.util.SpringJ2CacheConfigUtil;
import io.github.novareseller.cache.support.util.SpringUtil;
import java.io.IOException;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.J2Cache;
import net.oschina.j2cache.J2CacheBuilder;
import net.oschina.j2cache.J2CacheConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.StandardEnvironment;

@ConditionalOnClass(value={J2Cache.class})
@EnableConfigurationProperties(value={J2CacheProperties.class})
@Configuration
@PropertySource(value={"${spring.dagger.cache.config-location}"}, encoding="UTF-8", ignoreResourceNotFound=true)
@ConditionalOnProperty(value={"spring.dagger.cache.open-spring-cache"}, havingValue="true")
public class J2CacheAutoConfiguration {
    @Autowired
    private StandardEnvironment standardEnvironment;

    @Bean
    public J2CacheConfig j2CacheConfig() throws IOException {
        J2CacheConfig cacheConfig = SpringJ2CacheConfigUtil.initFromConfig(this.standardEnvironment);
        return cacheConfig;
    }

    @Bean
    @DependsOn(value={"springUtil", "j2CacheConfig"})
    public CacheChannel cacheChannel(J2CacheConfig j2CacheConfig) throws IOException {
        J2CacheBuilder builder = J2CacheBuilder.init((J2CacheConfig)j2CacheConfig);
        return builder.getChannel();
    }

    @Bean
    public SpringUtil springUtil() {
        return new SpringUtil();
    }
}

