/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.support.redis;

import net.oschina.j2cache.cluster.ClusterPolicy;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class SpringRedisActiveMessageListener
implements MessageListener {
    private String namespace;
    private ClusterPolicy clusterPolicy;
    private static final String COLON = ":";

    SpringRedisActiveMessageListener(ClusterPolicy clusterPolicy, String namespace) {
        this.clusterPolicy = clusterPolicy;
        this.namespace = namespace;
    }

    public void onMessage(Message message, byte[] pattern) {
        String key = message.toString();
        if (key == null) {
            return;
        }
        if (key.startsWith(this.namespace + COLON)) {
            String[] k = key.replaceFirst(this.namespace + COLON, "").split(COLON, 2);
            if (k.length != 2) {
                return;
            }
            this.clusterPolicy.evict(k[0], new String[]{k[1]});
        }
    }
}

