/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.support.redis;

import io.github.novareseller.cache.properties.J2CacheProperties;
import io.github.novareseller.cache.support.redis.ConfigureNotifyKeyspaceEventsAction;
import io.github.novareseller.cache.support.redis.SpringRedisActiveMessageListener;
import io.github.novareseller.cache.support.redis.SpringRedisMessageListener;
import io.github.novareseller.cache.support.util.SpringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.Command;
import net.oschina.j2cache.J2CacheConfig;
import net.oschina.j2cache.cluster.ClusterPolicy;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

public class SpringRedisPubSubPolicy
implements ClusterPolicy {
    private int LOCAL_COMMAND_ID = Command.genRandomSrc();
    private RedisTemplate<String, Serializable> redisTemplate;
    private J2CacheProperties config;
    private CacheProviderHolder holder;
    private static boolean isActive = false;
    private String channel = "j2cache_channel";

    public boolean isLocalCommand(Command cmd) {
        return cmd.getSrc() == this.LOCAL_COMMAND_ID;
    }

    public void connect(Properties props, CacheProviderHolder holder) {
        this.holder = holder;
        this.config = SpringUtil.getBean(J2CacheProperties.class);
        if (!this.config.isL2CacheOpen()) {
            return;
        }
        J2CacheConfig j2config = SpringUtil.getBean(J2CacheConfig.class);
        this.redisTemplate = SpringUtil.getBean("cacheRedisTemplate", RedisTemplate.class);
        String channel_name = j2config.getL2CacheProperties().getProperty("channel");
        if (channel_name != null && !channel_name.isEmpty()) {
            this.channel = channel_name;
        }
        RedisMessageListenerContainer listenerContainer = SpringUtil.getBean("j2CacheRedisMessageListenerContainer", RedisMessageListenerContainer.class);
        String namespace = j2config.getL2CacheProperties().getProperty("namespace");
        String database = j2config.getL2CacheProperties().getProperty("database");
        String expired = "__keyevent@" + (database == null || "".equals(database) ? "0" : database) + "__:expired";
        String del = "__keyevent@" + (database == null || "".equals(database) ? "0" : database) + "__:del";
        ArrayList<PatternTopic> topics = new ArrayList<PatternTopic>();
        topics.add(new PatternTopic(expired));
        topics.add(new PatternTopic(del));
        if ("active".equals(this.config.getCacheCleanMode())) {
            isActive = true;
            ConfigureNotifyKeyspaceEventsAction action = new ConfigureNotifyKeyspaceEventsAction();
            action.config(listenerContainer.getConnectionFactory().getConnection());
            listenerContainer.addMessageListener((MessageListener)new SpringRedisActiveMessageListener(this, namespace), topics);
        } else if ("aws-cluster-active".equals(this.config.getCacheCleanMode())) {
            isActive = true;
            listenerContainer.addMessageListener((MessageListener)new SpringRedisActiveMessageListener(this, namespace), topics);
        } else if ("blend".equals(this.config.getCacheCleanMode())) {
            ConfigureNotifyKeyspaceEventsAction action = new ConfigureNotifyKeyspaceEventsAction();
            action.config(listenerContainer.getConnectionFactory().getConnection());
            listenerContainer.addMessageListener((MessageListener)new SpringRedisActiveMessageListener(this, namespace), topics);
            listenerContainer.addMessageListener((MessageListener)new SpringRedisMessageListener(this, this.channel), (Topic)new PatternTopic(this.channel));
        } else if ("aws-cluster-blend".equals(this.config.getCacheCleanMode())) {
            listenerContainer.addMessageListener((MessageListener)new SpringRedisActiveMessageListener(this, namespace), topics);
            listenerContainer.addMessageListener((MessageListener)new SpringRedisMessageListener(this, this.channel), (Topic)new PatternTopic(this.channel));
        } else {
            listenerContainer.addMessageListener((MessageListener)new SpringRedisMessageListener(this, this.channel), (Topic)new PatternTopic(this.channel));
        }
    }

    public void evict(String region, String ... keys) {
        this.holder.getLevel1Cache(region).evict(keys);
    }

    public void clear(String region) {
        this.holder.getLevel1Cache(region).clear();
    }

    public void publish(Command cmd) {
        if (!isActive && this.config.isL2CacheOpen()) {
            cmd.setSrc(this.LOCAL_COMMAND_ID);
            this.redisTemplate.convertAndSend(this.channel, (Object)cmd.json());
        }
    }

    public void disconnect() {
        if (!isActive && this.config.isL2CacheOpen()) {
            Command cmd = new Command();
            cmd.setSrc(this.LOCAL_COMMAND_ID);
            cmd.setOperator(4);
            this.redisTemplate.convertAndSend(this.channel, (Object)cmd.json());
        }
    }
}

