/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.support.util;

import java.io.IOException;
import net.oschina.j2cache.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class J2CacheSerializer
implements RedisSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(J2CacheSerializer.class);

    public byte[] serialize(Object t) throws SerializationException {
        try {
            return SerializationUtils.serialize((Object)t);
        }
        catch (IOException e) {
            log.error("Object serialize error");
            return null;
        }
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        try {
            return SerializationUtils.deserialize((byte[])bytes);
        }
        catch (IOException e) {
            log.error("Bytes deserialize error");
            return null;
        }
    }
}

