/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.aop;

import io.github.novareseller.cache.annotation.DistributedLock;
import io.github.novareseller.cache.enums.LockModel;
import io.github.novareseller.cache.exception.LockException;
import io.github.novareseller.cache.properties.RedissonProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.Order;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
@Order(value=-10)
public class DistributedLockAop {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private RedissonClient redissonClient;

    @Pointcut(value="@annotation(distributedLock)")
    public void controllerAspect(DistributedLock distributedLock) {
    }

    @Around(value="controllerAspect(distributedLock)")
    public Object aroundAdvice(ProceedingJoinPoint proceedingJoinPoint, DistributedLock distributedLock) throws Throwable {
        LockModel lockModel;
        long lockWatchdogTimeout;
        String[] keys = distributedLock.keys();
        if (keys.length == 0) {
            throw new RuntimeException("keys cannot be empty");
        }
        String[] parameterNames = new LocalVariableTableParameterNameDiscoverer().getParameterNames(((MethodSignature)proceedingJoinPoint.getSignature()).getMethod());
        Object[] args = proceedingJoinPoint.getArgs();
        long attemptTimeout = distributedLock.attemptTimeout();
        if (attemptTimeout == 0L) {
            attemptTimeout = this.redissonProperties.getAttemptTimeout();
        }
        if ((lockWatchdogTimeout = distributedLock.lockWatchdogTimeout()) == 0L) {
            lockWatchdogTimeout = this.redissonProperties.getLockWatchdogTimeout();
        }
        if ((lockModel = distributedLock.lockModel()).equals((Object)LockModel.AUTO)) {
            LockModel lockModel1 = this.redissonProperties.getLockModel();
            lockModel = lockModel1 != null ? lockModel1 : (keys.length > 1 ? LockModel.REDLOCK : LockModel.REENTRANT);
        }
        if (!lockModel.equals((Object)LockModel.MULTIPLE) && !lockModel.equals((Object)LockModel.REDLOCK) && keys.length > 1) {
            throw new RuntimeException("There are multiple parameters, and the lock mode is->" + lockModel.name() + ".Can't lock");
        }
        this.log.info("Lock mode -> {}, wait for lock time -> {} seconds. Maximum lock time -> {} seconds", new Object[]{lockModel.name(), attemptTimeout / 1000L, lockWatchdogTimeout / 1000L});
        boolean res = false;
        RLock rLock = null;
        switch (lockModel) {
            case FAIR: {
                rLock = this.redissonClient.getFairLock(this.getVauleBySpel(keys[0], parameterNames, args, distributedLock.keyConstant()).get(0));
                break;
            }
            case REDLOCK: {
                ArrayList<RLock> rLocks = new ArrayList<RLock>();
                for (String key : keys) {
                    List<String> vauleBySpel = this.getVauleBySpel(key, parameterNames, args, distributedLock.keyConstant());
                    for (String s : vauleBySpel) {
                        rLocks.add(this.redissonClient.getLock(s));
                    }
                }
                RLock[] rLockArray = new RLock[rLocks.size()];
                int index = 0;
                for (RLock r : rLocks) {
                    rLockArray[index++] = r;
                }
                rLock = new RedissonRedLock(rLockArray);
                break;
            }
            case MULTIPLE: {
                ArrayList<RLock> rLocks = new ArrayList();
                for (String key : keys) {
                    List<String> vauleBySpel = this.getVauleBySpel(key, parameterNames, args, distributedLock.keyConstant());
                    for (String s : vauleBySpel) {
                        rLocks.add(this.redissonClient.getLock(s));
                    }
                }
                RLock[] rLockArray = new RLock[rLocks.size()];
                int index = 0;
                for (RLock r : rLocks) {
                    rLockArray[index++] = r;
                }
                rLock = new RedissonMultiLock(rLockArray);
                break;
            }
            case REENTRANT: {
                List<String> vauleBySpel = this.getVauleBySpel(keys[0], parameterNames, args, distributedLock.keyConstant());
                if (vauleBySpel.size() == 1) {
                    rLock = this.redissonClient.getLock(vauleBySpel.get(0));
                    break;
                }
                RLock[] rLockArray = new RLock[vauleBySpel.size()];
                int index = 0;
                for (String s : vauleBySpel) {
                    rLockArray[index++] = this.redissonClient.getLock(s);
                }
                rLock = new RedissonRedLock(rLockArray);
                break;
            }
            case READ: {
                RReadWriteLock rwlock = this.redissonClient.getReadWriteLock(this.getVauleBySpel(keys[0], parameterNames, args, distributedLock.keyConstant()).get(0));
                rLock = rwlock.readLock();
                break;
            }
            case WRITE: {
                RReadWriteLock rwlock1 = this.redissonClient.getReadWriteLock(this.getVauleBySpel(keys[0], parameterNames, args, distributedLock.keyConstant()).get(0));
                rLock = rwlock1.writeLock();
            }
        }
        if (rLock != null) {
            try {
                if (attemptTimeout == -1L) {
                    res = true;
                    rLock.lock(lockWatchdogTimeout, TimeUnit.MILLISECONDS);
                } else {
                    res = rLock.tryLock(attemptTimeout, lockWatchdogTimeout, TimeUnit.MILLISECONDS);
                }
                if (res) {
                    Object obj;
                    Object object = obj = proceedingJoinPoint.proceed();
                    return object;
                }
                throw new LockException("Failed to acquire lock");
            }
            finally {
                if (res) {
                    rLock.unlock();
                }
            }
        }
        throw new LockException("Failed to acquire lock");
    }

    public List<String> getVauleBySpel(String key, String[] parameterNames, Object[] values, String keyConstant) {
        ArrayList<String> keys = new ArrayList<String>();
        if (!key.contains("#")) {
            String s = "redisson:lock:" + key + keyConstant;
            this.log.info("No spel expression used value->{}", (Object)s);
            keys.add(s);
            return keys;
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < parameterNames.length; ++i) {
            context.setVariable(parameterNames[i], values[i]);
        }
        Expression expression = parser.parseExpression(key);
        Object value = expression.getValue((EvaluationContext)context);
        if (value != null) {
            if (value instanceof List) {
                List value1 = (List)value;
                for (Object o : value1) {
                    keys.add("redisson:lock:" + o.toString() + keyConstant);
                }
            } else if (value.getClass().isArray()) {
                Object[] obj;
                for (Object o : obj = (Object[])value) {
                    keys.add("redisson:lock:" + o.toString() + keyConstant);
                }
            } else {
                keys.add("redisson:lock:" + value.toString() + keyConstant);
            }
        }
        this.log.info("spel expression key={},value={}", (Object)key, keys);
        return keys;
    }
}

