/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.autoconfigure;

import io.github.novareseller.cache.autoconfigure.J2CacheAutoConfiguration;
import io.github.novareseller.cache.support.util.J2CacheSerializer;
import io.github.novareseller.cache.support.util.RedisUtil;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.oschina.j2cache.J2CacheConfig;
import net.oschina.j2cache.redis.RedisUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@AutoConfigureBefore(value={J2CacheAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.dagger.cache.l2-cache-open"}, havingValue="true", matchIfMissing=false)
public class J2CacheSpringRedisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(J2CacheSpringRedisAutoConfiguration.class);

    @Bean(value={"j2CacheRedisConnectionFactory"}, destroyMethod="destroy")
    @ConditionalOnMissingBean(name={"j2CacheRedisConnectionFactory"})
    @ConditionalOnProperty(name={"spring.dagger.cache.redis-client"}, havingValue="jedis", matchIfMissing=true)
    public JedisConnectionFactory jedisConnectionFactory(J2CacheConfig j2CacheConfig) {
        Properties l2CacheProperties = j2CacheConfig.getL2CacheProperties();
        String hosts = l2CacheProperties.getProperty("hosts");
        String mode = l2CacheProperties.getProperty("mode") == null ? "null" : l2CacheProperties.getProperty("mode");
        String clusterName = l2CacheProperties.getProperty("cluster_name");
        String password = l2CacheProperties.getProperty("password");
        int database = l2CacheProperties.getProperty("database") == null ? 0 : Integer.parseInt(l2CacheProperties.getProperty("database"));
        JedisConnectionFactory connectionFactory = null;
        JedisPoolConfig config = RedisUtils.newPoolConfig((Properties)l2CacheProperties, null);
        List<RedisNode> nodes = this.getRedisNodes(hosts);
        RedisPassword paw = RedisPassword.none();
        if (!StringUtils.isEmpty((Object)password)) {
            paw = RedisPassword.of((String)password);
        }
        switch (mode) {
            case "sentinel": {
                RedisSentinelConfiguration sentinel = new RedisSentinelConfiguration();
                sentinel.setDatabase(database);
                sentinel.setPassword(paw);
                sentinel.setMaster(clusterName);
                sentinel.setSentinels(nodes);
                connectionFactory = new JedisConnectionFactory(sentinel, config);
                break;
            }
            case "cluster": {
                RedisClusterConfiguration cluster = new RedisClusterConfiguration();
                cluster.setClusterNodes(nodes);
                cluster.setMaxRedirects(3);
                cluster.setPassword(paw);
                connectionFactory = new JedisConnectionFactory(cluster, config);
                break;
            }
            case "sharded": {
                try {
                    String[] stringArray = hosts.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    if (n2 >= n) break;
                    String node = stringArray[n2];
                    connectionFactory = new JedisConnectionFactory(new JedisShardInfo(new URI(node)));
                    connectionFactory.setPoolConfig(config);
                    log.warn("Jedis mode [sharded] not recommended for use!!");
                    break;
                }
                catch (URISyntaxException e) {
                    throw new JedisConnectionException((Throwable)e);
                }
            }
            default: {
                Iterator<RedisNode> iterator = nodes.iterator();
                if (iterator.hasNext()) {
                    RedisNode node = iterator.next();
                    String host = node.getHost();
                    int port = node.getPort();
                    RedisStandaloneConfiguration single = new RedisStandaloneConfiguration(host, port);
                    single.setDatabase(database);
                    single.setPassword(paw);
                    JedisClientConfiguration.JedisClientConfigurationBuilder clientConfiguration = JedisClientConfiguration.builder();
                    clientConfiguration.usePooling().poolConfig((GenericObjectPoolConfig)config);
                    clientConfiguration.connectTimeout(Duration.ofMillis(5000L));
                    connectionFactory = new JedisConnectionFactory(single, clientConfiguration.build());
                }
                if ("single".equalsIgnoreCase(mode)) break;
                log.warn("Redis mode [" + mode + "] not defined. Using 'single'.");
            }
        }
        return connectionFactory;
    }

    @Primary
    @Bean(value={"j2CacheRedisConnectionFactory"}, destroyMethod="destroy")
    @ConditionalOnMissingBean(name={"j2CacheRedisConnectionFactory"})
    @ConditionalOnProperty(name={"spring.dagger.cache.redis-client"}, havingValue="lettuce")
    public LettuceConnectionFactory lettuceConnectionFactory(J2CacheConfig j2CacheConfig) {
        Properties l2CacheProperties = j2CacheConfig.getL2CacheProperties();
        String hosts = l2CacheProperties.getProperty("hosts");
        String mode = l2CacheProperties.getProperty("mode") == null ? "null" : l2CacheProperties.getProperty("mode");
        String clusterName = l2CacheProperties.getProperty("cluster_name");
        String password = l2CacheProperties.getProperty("password");
        int database = l2CacheProperties.getProperty("database") == null ? 0 : Integer.parseInt(l2CacheProperties.getProperty("database"));
        LettuceConnectionFactory connectionFactory = null;
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder configBuilder = LettucePoolingClientConfiguration.builder();
        configBuilder.commandTimeout(Duration.ofMillis(5000L));
        configBuilder.poolConfig(this.getGenericRedisPool(l2CacheProperties, null));
        List<RedisNode> nodes = this.getRedisNodes(hosts);
        RedisPassword paw = RedisPassword.none();
        if (!StringUtils.isEmpty((Object)password)) {
            paw = RedisPassword.of((String)password);
        }
        switch (mode) {
            case "sentinel": {
                RedisSentinelConfiguration sentinel = new RedisSentinelConfiguration();
                sentinel.setDatabase(database);
                sentinel.setPassword(paw);
                sentinel.setMaster(clusterName);
                sentinel.setSentinels(nodes);
                connectionFactory = new LettuceConnectionFactory(sentinel, (LettuceClientConfiguration)configBuilder.build());
                break;
            }
            case "cluster": {
                RedisClusterConfiguration cluster = new RedisClusterConfiguration();
                cluster.setClusterNodes(nodes);
                cluster.setMaxRedirects(3);
                cluster.setPassword(paw);
                ClusterTopologyRefreshOptions topologyRefreshOptions = ClusterTopologyRefreshOptions.builder().enableAdaptiveRefreshTrigger(new ClusterTopologyRefreshOptions.RefreshTrigger[]{ClusterTopologyRefreshOptions.RefreshTrigger.MOVED_REDIRECT, ClusterTopologyRefreshOptions.RefreshTrigger.PERSISTENT_RECONNECTS}).adaptiveRefreshTriggersTimeout(Duration.ofSeconds(25L)).enablePeriodicRefresh(Duration.ofSeconds(20L)).build();
                LettucePoolingClientConfiguration configuration = configBuilder.clientOptions((ClientOptions)ClusterClientOptions.builder().topologyRefreshOptions(topologyRefreshOptions).build()).build();
                connectionFactory = new LettuceConnectionFactory(cluster, (LettuceClientConfiguration)configuration);
                break;
            }
            case "sharded": {
                throw new IllegalArgumentException("Lettuce not support use mode [sharded]!!");
            }
            default: {
                Iterator<RedisNode> iterator = nodes.iterator();
                if (iterator.hasNext()) {
                    RedisNode node = iterator.next();
                    String host = node.getHost();
                    int port = node.getPort();
                    RedisStandaloneConfiguration single = new RedisStandaloneConfiguration(host, port);
                    single.setDatabase(database);
                    single.setPassword(paw);
                    connectionFactory = new LettuceConnectionFactory(single, (LettuceClientConfiguration)configBuilder.build());
                }
                if ("single".equalsIgnoreCase(mode)) break;
                log.warn("Redis mode [" + mode + "] not defined. Using 'single'.");
            }
        }
        return connectionFactory;
    }

    @Bean(value={"cacheRedisTemplate"})
    public RedisTemplate<String, Serializable> cacheRedisTemplate(@Qualifier(value="j2CacheRedisConnectionFactory") RedisConnectionFactory j2CacheRedisConnectionFactory, @Qualifier(value="j2CacheValueSerializer") RedisSerializer<Object> j2CacheSerializer) {
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setDefaultSerializer(j2CacheSerializer);
        template.setConnectionFactory(j2CacheRedisConnectionFactory);
        return template;
    }

    @Bean(value={"j2CacheValueSerializer"})
    @ConditionalOnMissingBean(name={"j2CacheValueSerializer"})
    public RedisSerializer<Object> j2CacheValueSerializer() {
        return new J2CacheSerializer();
    }

    @Bean
    @ConditionalOnMissingBean(value={StringRedisTemplate.class})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={HashOperations.class})
    public HashOperations<String, String, String> hashOperations(StringRedisTemplate stringRedisTemplate) {
        return stringRedisTemplate.opsForHash();
    }

    @Bean(value={"redisUtil"})
    public RedisUtil redisUtil(@Qualifier(value="j2CacheRedisConnectionFactory") RedisConnectionFactory redisConnectionFactory, StringRedisTemplate stringRedisTemplate, HashOperations<String, String, String> hashOperations) {
        RedisUtil redisUtil = new RedisUtil(redisConnectionFactory, stringRedisTemplate, hashOperations);
        return redisUtil;
    }

    @Bean(value={"j2CacheRedisMessageListenerContainer"})
    RedisMessageListenerContainer container(@Qualifier(value="j2CacheRedisConnectionFactory") RedisConnectionFactory j2CacheRedisConnectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(j2CacheRedisConnectionFactory);
        return container;
    }

    private GenericObjectPoolConfig getGenericRedisPool(Properties props, String prefix) {
        GenericObjectPoolConfig cfg = new GenericObjectPoolConfig();
        cfg.setMaxTotal(Integer.valueOf((String)props.getOrDefault((Object)this.key(prefix, "maxTotal"), "-1")).intValue());
        cfg.setMaxIdle(Integer.valueOf((String)props.getOrDefault((Object)this.key(prefix, "maxIdle"), "100")).intValue());
        cfg.setMaxWaitMillis((long)Integer.valueOf((String)props.getOrDefault((Object)this.key(prefix, "maxWaitMillis"), "100")).intValue());
        cfg.setMinEvictableIdleTimeMillis((long)Integer.valueOf((String)props.getOrDefault((Object)this.key(prefix, "minEvictableIdleTimeMillis"), "864000000")).intValue());
        cfg.setMinIdle(Integer.valueOf((String)props.getOrDefault((Object)this.key(prefix, "minIdle"), "10")).intValue());
        cfg.setNumTestsPerEvictionRun(Integer.valueOf((String)props.getOrDefault((Object)this.key(prefix, "numTestsPerEvictionRun"), "10")).intValue());
        cfg.setLifo(Boolean.valueOf(props.getProperty(this.key(prefix, "lifo"), "false")).booleanValue());
        cfg.setSoftMinEvictableIdleTimeMillis((long)Integer.valueOf((String)props.getOrDefault((Object)this.key(prefix, "softMinEvictableIdleTimeMillis"), "10")).intValue());
        cfg.setTestOnBorrow(Boolean.valueOf(props.getProperty(this.key(prefix, "testOnBorrow"), "true")).booleanValue());
        cfg.setTestOnReturn(Boolean.valueOf(props.getProperty(this.key(prefix, "testOnReturn"), "false")).booleanValue());
        cfg.setTestWhileIdle(Boolean.valueOf(props.getProperty(this.key(prefix, "testWhileIdle"), "true")).booleanValue());
        cfg.setTimeBetweenEvictionRunsMillis((long)Integer.valueOf((String)props.getOrDefault((Object)this.key(prefix, "timeBetweenEvictionRunsMillis"), "300000")).intValue());
        cfg.setBlockWhenExhausted(Boolean.valueOf(props.getProperty(this.key(prefix, "blockWhenExhausted"), "false")).booleanValue());
        cfg.setJmxEnabled(Boolean.valueOf(props.getProperty(this.key(prefix, "jmxEnabled"), "false")).booleanValue());
        return cfg;
    }

    private List<RedisNode> getRedisNodes(String hosts) {
        ArrayList<RedisNode> nodes = new ArrayList<RedisNode>();
        if (hosts != null && !"".equals(hosts)) {
            for (String node : hosts.split(",")) {
                String[] s = node.split(":");
                String host = s[0];
                int port = s.length > 1 ? Integer.parseInt(s[1]) : 6379;
                RedisNode n = new RedisNode(host, port);
                nodes.add(n);
            }
        } else {
            log.error("redis configuration in j2cache lacks hosts.");
            throw new IllegalArgumentException();
        }
        return nodes;
    }

    private String key(String prefix, String key) {
        return prefix == null ? key : prefix + "." + key;
    }
}

