/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.autoconfigure;

import io.github.novareseller.cache.autoconfigure.J2CacheSpringRedisAutoConfiguration;
import io.github.novareseller.cache.autoconfigure.RedissonAutoConfigurationCustomizer;
import io.github.novareseller.cache.properties.RedissonProperties;
import io.github.novareseller.cache.support.util.SpringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.oschina.j2cache.J2CacheConfig;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBean(value={J2CacheConfig.class, J2CacheSpringRedisAutoConfiguration.class})
@AutoConfigureAfter(value={J2CacheSpringRedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedissonProperties.class})
@ConditionalOnProperty(value={"spring.dagger.cache.redisson.open"}, havingValue="true")
public class RedissonAutoConfiguration {
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";
    @Autowired(required=false)
    private List<RedissonAutoConfigurationCustomizer> redissonAutoConfigurationCustomizers;
    @Autowired
    private RedissonProperties redissonProperties;

    @Bean(value={"redissonConfig"})
    @DependsOn(value={"j2CacheConfig"})
    public Config redissonConfig(J2CacheConfig j2CacheConfig) {
        Config config;
        int timeout;
        Properties l2CacheProperties = j2CacheConfig.getL2CacheProperties();
        String hosts = l2CacheProperties.getProperty("hosts");
        String mode = l2CacheProperties.getProperty("mode") == null ? "null" : l2CacheProperties.getProperty("mode");
        String clusterName = l2CacheProperties.getProperty("cluster_name");
        String password = StringUtils.isEmpty((Object)l2CacheProperties.getProperty("password")) ? null : l2CacheProperties.getProperty("password");
        int database = l2CacheProperties.getProperty("database") == null ? 0 : Integer.parseInt(l2CacheProperties.getProperty("database"));
        boolean isSSL = l2CacheProperties.getProperty("isSsl") == null ? false : Boolean.valueOf(l2CacheProperties.getProperty("isSsl"));
        int n = timeout = l2CacheProperties.getProperty("timeout") == null ? 5000 : Integer.parseInt(l2CacheProperties.getProperty("timeout"));
        if (this.redissonProperties.getConfig() != null) {
            try {
                config = Config.fromYAML((String)this.redissonProperties.getConfig());
            }
            catch (IOException e) {
                try {
                    config = Config.fromJSON((String)this.redissonProperties.getConfig());
                }
                catch (IOException e1) {
                    throw new IllegalArgumentException("Can't parse config", e1);
                }
            }
        } else if (this.redissonProperties.getFile() != null) {
            try {
                InputStream is = this.getConfigStream();
                config = Config.fromYAML((InputStream)is);
            }
            catch (IOException e) {
                try {
                    InputStream is = this.getConfigStream();
                    config = Config.fromJSON((InputStream)is);
                }
                catch (IOException e1) {
                    throw new IllegalArgumentException("Can't parse config", e1);
                }
            }
        } else if ("sentinel".equalsIgnoreCase(mode)) {
            config = new Config();
            ((SentinelServersConfig)config.useSentinelServers().setMasterName(clusterName).addSentinelAddress(this.convert(hosts)).setDatabase(database).setConnectTimeout(timeout)).setPassword(password);
        } else if ("cluster".equalsIgnoreCase(mode)) {
            config = new Config();
            ((ClusterServersConfig)config.useClusterServers().addNodeAddress(this.convert(hosts)).setConnectTimeout(timeout)).setPassword(password);
        } else if ("single".equalsIgnoreCase(mode)) {
            config = new Config();
            String prefix = isSSL ? REDISS_PROTOCOL_PREFIX : REDIS_PROTOCOL_PREFIX;
            ((SingleServerConfig)config.useSingleServer().setAddress(prefix + hosts).setConnectTimeout(timeout)).setDatabase(database).setPassword(password);
        } else {
            throw new IllegalArgumentException("redisson not support use mode [sharded]!!");
        }
        if (this.redissonAutoConfigurationCustomizers != null) {
            for (RedissonAutoConfigurationCustomizer customizer : this.redissonAutoConfigurationCustomizers) {
                customizer.customize(config);
            }
        }
        return config;
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={RedissonClient.class})
    @DependsOn(value={"redissonConfig"})
    public RedissonClient redissonClient(Config config) {
        return Redisson.create((Config)config);
    }

    private String[] convert(String hosts) {
        String[] hostArr = hosts.split(",");
        ArrayList<String> nodes = new ArrayList<String>(hostArr.length);
        for (String host : hostArr) {
            if (!host.startsWith(REDIS_PROTOCOL_PREFIX) && !host.startsWith(REDISS_PROTOCOL_PREFIX)) {
                nodes.add(REDIS_PROTOCOL_PREFIX + host);
                continue;
            }
            nodes.add(host);
        }
        return nodes.toArray(new String[nodes.size()]);
    }

    private InputStream getConfigStream() throws IOException {
        Resource resource = SpringUtil.getApplicationContext().getResource(this.redissonProperties.getFile());
        InputStream is = resource.getInputStream();
        return is;
    }
}

