/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.support.redis;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.Level2Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class SpringRedisGenericCache
implements Level2Cache {
    private static final Logger log = LoggerFactory.getLogger(SpringRedisGenericCache.class);
    private String namespace;
    private String region;
    private RedisTemplate<String, Serializable> redisTemplate;

    public SpringRedisGenericCache(String namespace, String region, RedisTemplate<String, Serializable> redisTemplate) {
        if (region == null || region.isEmpty()) {
            region = "_";
        }
        this.namespace = namespace;
        this.redisTemplate = redisTemplate;
        this.region = this.getRegionName(region);
    }

    private String getRegionName(String region) {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            region = this.namespace + ":" + region;
        }
        return region;
    }

    public void clear() {
        Collection<String> keys = this.keys();
        keys.stream().forEach(k -> this.redisTemplate.delete((Object)(this.region + ":" + k)));
    }

    public boolean exists(String key) {
        return (Boolean)this.redisTemplate.execute(redis -> redis.exists(this._key(key)));
    }

    public void evict(String ... keys) {
        for (String k : keys) {
            this.redisTemplate.execute(redis -> redis.del((byte[][])new byte[][]{this._key(k)}));
        }
    }

    public Collection<String> keys() {
        return this.redisTemplate.keys((Object)(this.region + ":*")).stream().map(k -> k.substring(this.region.length() + 1)).collect(Collectors.toSet());
    }

    public byte[] getBytes(String key) {
        return (byte[])this.redisTemplate.execute(redis -> redis.get(this._key(key)));
    }

    public List<byte[]> getBytes(Collection<String> keys) {
        return (List)this.redisTemplate.execute(redis -> {
            byte[][] bytes = (byte[][])keys.stream().map(k -> this._key((String)k)).toArray(x$0 -> new byte[x$0][]);
            return redis.mGet(bytes);
        });
    }

    public void setBytes(String key, byte[] bytes, long timeToLiveInSeconds) {
        if (timeToLiveInSeconds <= 0L) {
            log.debug(String.format("Invalid timeToLiveInSeconds value : %d , skipped it.", timeToLiveInSeconds));
            this.setBytes(key, bytes);
        } else {
            this.redisTemplate.execute(redis -> {
                redis.setEx(this._key(key), (long)((int)timeToLiveInSeconds), bytes);
                return null;
            });
        }
    }

    public void setBytes(Map<String, byte[]> bytes, long timeToLiveInSeconds) {
        bytes.forEach((k, v) -> this.setBytes((String)k, (byte[])v, timeToLiveInSeconds));
    }

    public void setBytes(String key, byte[] bytes) {
        this.redisTemplate.execute(redis -> {
            redis.set(this._key(key), bytes);
            return null;
        });
    }

    public void setBytes(Map<String, byte[]> bytes) {
        bytes.forEach((k, v) -> this.setBytes((String)k, (byte[])v));
    }

    private byte[] _key(String key) {
        byte[] k;
        try {
            k = (this.region + ":" + key).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            k = (this.region + ":" + key).getBytes();
        }
        return k;
    }
}

