/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.support.redis;

import net.oschina.j2cache.Command;
import net.oschina.j2cache.cluster.ClusterPolicy;
import net.oschina.j2cache.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class SpringRedisMessageListener
implements MessageListener {
    private static Logger logger = LoggerFactory.getLogger(SpringRedisMessageListener.class);
    private int LOCAL_COMMAND_ID = Command.genRandomSrc();
    private ClusterPolicy clusterPolicy;
    private String channel;

    SpringRedisMessageListener(ClusterPolicy clusterPolicy, String channel) {
        this.clusterPolicy = clusterPolicy;
        this.channel = channel;
    }

    private boolean isLocalCommand(Command cmd) {
        return cmd.getSrc() == this.LOCAL_COMMAND_ID;
    }

    public void onMessage(Message message, byte[] pattern) {
        byte[] messageChannel = message.getChannel();
        byte[] messageBody = message.getBody();
        if (messageChannel == null || messageBody == null) {
            return;
        }
        try {
            Command cmd = Command.parse((String)String.valueOf(SerializationUtils.deserialize((byte[])messageBody)));
            if (cmd == null || this.isLocalCommand(cmd)) {
                return;
            }
            switch (cmd.getOperator()) {
                case 1: {
                    logger.info("Node-" + cmd.getSrc() + " joined to " + this.channel);
                    break;
                }
                case 2: {
                    this.clusterPolicy.evict(cmd.getRegion(), cmd.getKeys());
                    logger.debug("Received cache evict message, region=" + cmd.getRegion() + ",key=" + String.join((CharSequence)",", cmd.getKeys()));
                    break;
                }
                case 3: {
                    this.clusterPolicy.clear(cmd.getRegion());
                    logger.debug("Received cache clear message, region=" + cmd.getRegion());
                    break;
                }
                case 4: {
                    logger.info("Node-" + cmd.getSrc() + " quit to " + this.channel);
                    break;
                }
                default: {
                    logger.warn("Unknown message type = " + cmd.getOperator());
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to handle received msg", (Throwable)e);
        }
    }
}

