/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.support.redis;

import io.github.novareseller.cache.properties.J2CacheProperties;
import io.github.novareseller.cache.support.redis.SpringRedisCache;
import io.github.novareseller.cache.support.redis.SpringRedisGenericCache;
import io.github.novareseller.cache.support.util.SpringUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.NullCache;
import org.springframework.data.redis.core.RedisTemplate;

public class SpringRedisProvider
implements CacheProvider {
    private RedisTemplate<String, Serializable> redisTemplate;
    private J2CacheProperties config;
    private String namespace;
    private String storage;
    protected ConcurrentHashMap<String, Cache> caches = new ConcurrentHashMap();

    public String name() {
        return "redis";
    }

    public int level() {
        return 2;
    }

    public Collection<CacheChannel.Region> regions() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cache buildCache(String region, CacheExpiredListener listener) {
        if (!this.config.isL2CacheOpen()) {
            return new NullCache();
        }
        Object cache = this.caches.get(region);
        if (cache != null) return cache;
        Class<SpringRedisProvider> clazz = SpringRedisProvider.class;
        synchronized (SpringRedisProvider.class) {
            cache = this.caches.get(region);
            if (cache != null) return cache;
            cache = "hash".equalsIgnoreCase(this.storage) ? new SpringRedisCache(this.namespace, region, this.redisTemplate) : new SpringRedisGenericCache(this.namespace, region, this.redisTemplate);
            this.caches.put(region, (Cache)cache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cache;
        }
    }

    public Cache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        return this.buildCache(region, listener);
    }

    public void start(Properties props) {
        this.namespace = props.getProperty("namespace");
        this.storage = props.getProperty("storage");
        this.config = SpringUtil.getBean(J2CacheProperties.class);
        if (!this.config.isL2CacheOpen()) {
            return;
        }
        this.redisTemplate = SpringUtil.getBean("cacheRedisTemplate", RedisTemplate.class);
    }

    public void stop() {
    }
}

