/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.cache.support.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.CollectionUtils;

public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    private StringRedisTemplate stringRedisTemplate;
    private HashOperations<String, String, String> hashOperations;
    private RedisConnectionFactory redisConnectionFactory;
    private static GenericJackson2JsonRedisSerializer redisObjectSerializer = new GenericJackson2JsonRedisSerializer();
    private RedisTemplate<String, Object> redisTemplate;

    public RedisUtil(RedisConnectionFactory redisConnectionFactory, StringRedisTemplate stringRedisTemplate, HashOperations<String, String, String> hashOperations) {
        this.redisConnectionFactory = redisConnectionFactory;
        this.stringRedisTemplate = stringRedisTemplate;
        this.hashOperations = hashOperations;
        RedisTemplate redisTemplate = new RedisTemplate();
        GenericJackson2JsonRedisSerializer redisObjectSerializer = new GenericJackson2JsonRedisSerializer();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)redisObjectSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)redisObjectSerializer);
        redisTemplate.afterPropertiesSet();
        this.redisTemplate = redisTemplate;
    }

    public List<String> hashGet(String key, Collection<String> hashKeys) {
        List result = this.hashOperations.multiGet((Object)key, hashKeys);
        if (!CollectionUtils.isEmpty((Collection)result) && result.size() == 1 && result.get(0) == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public void hashPut(String key, String hash, String value) {
        this.hashOperations.put((Object)key, (Object)hash, (Object)value);
    }

    public Object hashDel(String key, String ... hash) {
        return this.hashOperations.delete((Object)key, (Object[])hash);
    }

    public String getMsg(String topicGroup, String channel) {
        return (String)this.hashOperations.get((Object)topicGroup, (Object)channel);
    }

    public boolean removeMsg(String topicGroup, String channel) {
        this.publishMsg(topicGroup, channel, "");
        return this.hashOperations.delete((Object)topicGroup, new Object[]{channel}) == 1L;
    }

    public boolean publishMsg(String topicGroup, String channel, String msg) {
        this.hashOperations.put((Object)topicGroup, (Object)channel, (Object)msg);
        this.stringRedisTemplate.convertAndSend(topicGroup + "-" + channel, (Object)msg);
        return true;
    }

    public void subscribeConfig(String msg, Consumer<String> consumer) {
        consumer.accept(msg);
    }

    public boolean expire(final String key, final long time) {
        return (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                long rawTimeout = TimeoutUtils.toMillis((long)time, (TimeUnit)TimeUnit.SECONDS);
                try {
                    return connection.pExpire(key.getBytes(), rawTimeout);
                }
                catch (Exception e) {
                    return connection.expire(key.getBytes(), TimeoutUtils.toSeconds((long)rawTimeout, (TimeUnit)TimeUnit.SECONDS));
                }
            }
        });
    }

    public long getExpire(final String key) {
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                try {
                    return connection.pTtl(key.getBytes(), TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    return connection.ttl(key.getBytes(), TimeUnit.SECONDS);
                }
            }
        });
    }

    public boolean hasKey(String key) {
        return (Boolean)this.redisTemplate.execute(connection -> connection.exists(key.getBytes()));
    }

    public Object get(final String key) {
        Object value = this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] temp = null;
                temp = connection.get(key.getBytes());
                connection.close();
                return redisObjectSerializer.deserialize(temp);
            }
        });
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.execute(connection -> {
                byte[] values = redisObjectSerializer.serialize(value);
                connection.set(key.getBytes(), values);
                connection.close();
                return 1L;
            });
            return true;
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("set-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.execute(connection -> {
                    byte[] values = redisObjectSerializer.serialize(value);
                    connection.set(key.getBytes(), values);
                    connection.expire(key.getBytes(), 60L * time);
                    connection.close();
                    return 1L;
                });
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("set-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return (Long)this.redisTemplate.execute(connection -> connection.incrBy(key.getBytes(), delta));
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return (Long)this.redisTemplate.execute(connection -> connection.incrBy(key.getBytes(), -delta));
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public boolean setBit(String key, long offset, boolean isShow) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.setBit((Object)key, offset, isShow);
            result = true;
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("setBit-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return false;
        }
        return result;
    }

    public boolean getBit(String key, long offset) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            result = operations.getBit((Object)key, offset);
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("getBit-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return false;
        }
        return result;
    }

    public void pushToQueue(String key, String value) {
        this.stringRedisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public String popFromQueue(String key) {
        return (String)this.stringRedisTemplate.opsForList().rightPop((Object)key);
    }

    public long getQueueSize(String key) {
        Long size = this.stringRedisTemplate.opsForList().size((Object)key);
        return size == null ? 0L : size;
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("lGet-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("lGetListSize-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("lGetIndex-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("lSet-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("lSet-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("lSet-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("lSet-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("lUpdateIndex-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            log.error("lRemove-" + stackTraceElement.getMethodName() + "--" + stackTraceElement.getLineNumber());
            return 0L;
        }
    }

    public void hmSet(String key, Object hashKey, Object value) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.put((Object)key, hashKey, value);
    }

    public Object hmGet(String key, Object hashKey) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.get((Object)key, hashKey);
    }

    public void add(String key, Object value) {
        SetOperations set = this.redisTemplate.opsForSet();
        set.add((Object)key, new Object[]{value});
    }

    public Set<Object> setMembers(String key) {
        SetOperations set = this.redisTemplate.opsForSet();
        return set.members((Object)key);
    }

    public void zAdd(String key, Object value, double scoure) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        zset.add((Object)key, value, scoure);
    }

    public Set<Object> rangeByScore(String key, double scoure, double scoure1) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        this.redisTemplate.opsForValue();
        return zset.rangeByScore((Object)key, scoure, scoure1);
    }

    public Long zRank(String key, Object value) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.rank((Object)key, value);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRankWithScore(String key, long start, long end) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        Set ret = zset.rangeWithScores((Object)key, start, end);
        return ret;
    }

    public Double zSetScore(String key, Object value) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.score((Object)key, value);
    }

    public void incrementScore(String key, Object value, double scoure) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        zset.incrementScore((Object)key, value, scoure);
    }

    public Set<ZSetOperations.TypedTuple<Object>> reverseZRankWithScore(String key, long start, long end) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        Set ret = zset.reverseRangeByScoreWithScores((Object)key, (double)start, (double)end);
        return ret;
    }

    public Set<ZSetOperations.TypedTuple<Object>> reverseZRankWithRank(String key, long start, long end) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        Set ret = zset.reverseRangeWithScores((Object)key, start, end);
        return ret;
    }
}

