/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.log.configuration;

import io.github.novareseller.log.configuration.LogSpringAware;
import io.github.novareseller.log.context.LogContext;
import io.github.novareseller.log.context.LogLabelGenerator;
import io.github.novareseller.log.id.LogIdGenerator;
import io.github.novareseller.log.id.LogIdGeneratorLoader;
import io.github.novareseller.tool.text.StringUtil;
import io.github.novareseller.tool.utils.Validator;
import org.springframework.beans.factory.InitializingBean;

public class LogPropertyInit
implements InitializingBean {
    private String pattern;
    private Boolean enableInvokeTimePrint;
    private String idGenerator;
    private Boolean mdcEnable;

    public void afterPropertiesSet() throws Exception {
        if (StringUtil.isNotBlank((CharSequence)this.pattern)) {
            LogLabelGenerator.setLabelPattern(this.pattern);
        }
        if (!Validator.isNullOrEmpty((Object)this.enableInvokeTimePrint)) {
            LogContext.setEnableInvokeTimePrint(this.enableInvokeTimePrint);
        }
        if (StringUtil.isNotBlank((CharSequence)this.idGenerator)) {
            try {
                LogIdGenerator logIdGenerator = (LogIdGenerator)LogSpringAware.registerBean(Class.forName(this.idGenerator));
                LogIdGeneratorLoader.setIdGenerator(logIdGenerator);
            }
            catch (Exception e) {
                throw new RuntimeException("Id generator package path is incorrect");
            }
        }
        if (Boolean.TRUE.equals(this.mdcEnable)) {
            LogContext.setHasLogMDC(true);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Boolean getEnableInvokeTimePrint() {
        return this.enableInvokeTimePrint;
    }

    public void setEnableInvokeTimePrint(Boolean enableInvokeTimePrint) {
        this.enableInvokeTimePrint = enableInvokeTimePrint;
    }

    public String getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(String idGenerator) {
        this.idGenerator = idGenerator;
    }

    public Boolean getMdcEnable() {
        return this.mdcEnable;
    }

    public void setMdcEnable(Boolean mdcEnable) {
        this.mdcEnable = mdcEnable;
    }
}

