/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.log.handler;

import io.github.novareseller.log.context.AspectLogContext;
import io.github.novareseller.log.context.LogContext;
import io.github.novareseller.log.context.LogLabelGenerator;
import io.github.novareseller.log.handler.LogLabelBean;
import io.github.novareseller.log.id.LogIdGeneratorLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogHandler {
    protected static final Logger log = LoggerFactory.getLogger(LogHandler.class);

    public void processProviderSide(LogLabelBean labelBean) {
        if (StringUtils.isBlank((CharSequence)labelBean.getPreIvkApp())) {
            labelBean.setPreIvkApp("NONE");
        }
        LogContext.putPreIvkApp(labelBean.getPreIvkApp());
        if (StringUtils.isBlank((CharSequence)labelBean.getPreIvkHost())) {
            labelBean.setPreIvkHost("NONE");
        }
        LogContext.putPreIvkHost(labelBean.getPreIvkHost());
        if (StringUtils.isBlank((CharSequence)labelBean.getPreIp())) {
            labelBean.setPreIp("NONE");
        }
        LogContext.putPreIp(labelBean.getPreIp());
        if (StringUtils.isBlank((CharSequence)labelBean.getTraceId())) {
            labelBean.setTraceId(LogIdGeneratorLoader.getIdGenerator().generateTraceId());
            log.debug("Maybe the previous node [{}] did not pass the traceId correctly, regenerate the traceId[{}]", (Object)labelBean.getPreIvkApp(), (Object)labelBean.getTraceId());
        }
        LogContext.putSpanId(labelBean.getSpanId());
        LogContext.putTraceId(labelBean.getTraceId());
        String logLabel = LogLabelGenerator.generateLogLabel(labelBean.getPreIvkApp(), labelBean.getPreIvkHost(), labelBean.getPreIp(), labelBean.getTraceId(), LogContext.getSpanId());
        AspectLogContext.putLogValue(logLabel);
        if (LogContext.hasLogMDC()) {
            MDC.put((String)"mdc-var", (String)logLabel);
        }
    }

    public void cleanThreadLocal() {
        LogContext.removePreIvkApp();
        LogContext.removePreIvkHost();
        LogContext.removePreIp();
        LogContext.removeTraceId();
        LogContext.removeSpanId();
        AspectLogContext.remove();
        if (LogContext.hasLogMDC()) {
            MDC.remove((String)"mdc-var");
        }
    }
}

