/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.log.thread;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.MDC;

public abstract class LogInheritableTask
implements Runnable {
    private Object obj;
    private static volatile Field inheritableThreadLocalsField;
    private static volatile Class threadLocalMapClazz;
    private static volatile Method createInheritedMapMethod;
    private static final Object accessLock;
    private final Map<String, String> _cm = MDC.getCopyOfContextMap();

    public LogInheritableTask() {
        try {
            Thread currentThread = Thread.currentThread();
            Field field = this.getInheritableThreadLocalsField();
            Object threadLocalMapObj = field.get(currentThread);
            if (threadLocalMapObj != null) {
                Object newThreadLocalMap;
                Class threadLocalMapClazz = this.getThreadLocalMapClazz();
                Method method = this.getCreateInheritedMapMethod(threadLocalMapClazz);
                this.obj = newThreadLocalMap = method.invoke(ThreadLocal.class, threadLocalMapObj);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getThreadLocalMapClazz() {
        if (inheritableThreadLocalsField == null) {
            return null;
        }
        if (threadLocalMapClazz == null) {
            Object object = accessLock;
            synchronized (object) {
                if (threadLocalMapClazz == null) {
                    Class<?> clazz;
                    threadLocalMapClazz = clazz = inheritableThreadLocalsField.getType();
                }
            }
        }
        return threadLocalMapClazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Field getInheritableThreadLocalsField() {
        if (inheritableThreadLocalsField == null) {
            Object object = accessLock;
            synchronized (object) {
                if (inheritableThreadLocalsField == null) {
                    try {
                        Field field = Thread.class.getDeclaredField("inheritableThreadLocals");
                        field.setAccessible(true);
                        inheritableThreadLocalsField = field;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
        return inheritableThreadLocalsField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getCreateInheritedMapMethod(Class threadLocalMapClazz) {
        if (threadLocalMapClazz != null && createInheritedMapMethod == null) {
            Object object = accessLock;
            synchronized (object) {
                if (createInheritedMapMethod == null) {
                    try {
                        Method method = ThreadLocal.class.getDeclaredMethod("createInheritedMap", threadLocalMapClazz);
                        method.setAccessible(true);
                        createInheritedMapMethod = method;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
        return createInheritedMapMethod;
    }

    public abstract void runTask();

    @Override
    public final void run() {
        boolean isSet = false;
        Thread currentThread = Thread.currentThread();
        Field field = this.getInheritableThreadLocalsField();
        if (this._cm != null) {
            MDC.setContextMap(this._cm);
        }
        try {
            if (this.obj != null && field != null) {
                field.set(currentThread, this.obj);
                this.obj = null;
                isSet = true;
            }
            this.runTask();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                field.set(currentThread, null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            MDC.clear();
        }
    }

    public void start() {
        new Thread(this).start();
    }

    static {
        accessLock = new Object();
    }
}

