/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.log.aop;

import cn.hutool.json.JSONUtil;
import com.google.common.collect.Maps;
import io.github.novareseller.log.annotation.LogAspect;
import io.github.novareseller.log.context.AspectLogContext;
import io.github.novareseller.log.context.LogContext;
import io.github.novareseller.log.convert.AspectLogConvert;
import io.github.novareseller.tool.date.DateUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Aspect
public class AspectLogAop {
    private static final Logger log = LoggerFactory.getLogger(AspectLogAop.class);

    @Pointcut(value="@annotation(io.github.novareseller.log.annotation.LogAspect)")
    public void cut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="cut()")
    public Object around(ProceedingJoinPoint jp) throws Throwable {
        String aspLogValue;
        Object[] args = jp.getArgs();
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        String[] parameterNames = signature.getParameterNames();
        HashMap paramNameValueMap = Maps.newHashMap();
        for (int i = 0; i < parameterNames.length; ++i) {
            paramNameValueMap.put(parameterNames[i], args[i]);
        }
        LogAspect logAspect = method.getAnnotation(LogAspect.class);
        String[] aspectExpressions = logAspect.value();
        String pattern = logAspect.pattern().replaceAll("\\{\\}", "{0}");
        String joint = logAspect.joint();
        Class<? extends AspectLogConvert> convertClazz = logAspect.convert();
        StringBuilder sb = new StringBuilder();
        if (!convertClazz.equals(AspectLogConvert.class)) {
            AspectLogConvert convert = convertClazz.newInstance();
            try {
                sb.append(convert.convert(args));
            }
            catch (Throwable t) {
                log.error("[AspectLog]some errors happens in AspectLog's convert", t);
            }
        } else {
            for (String aspectExpression : aspectExpressions) {
                String aspLogValueItem = this.getExpressionValue(aspectExpression, paramNameValueMap);
                if (!StringUtils.isNotBlank((CharSequence)aspLogValueItem)) continue;
                sb.append(String.format("%s:%s", aspectExpression, aspLogValueItem));
                sb.append(joint);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(aspLogValue = sb.toString()))) {
            aspLogValue = aspLogValue.substring(0, aspLogValue.length() - joint.length());
            aspLogValue = MessageFormat.format(pattern, aspLogValue);
            String currentLabel = AspectLogContext.getLogValue();
            if (LogContext.hasLogMDC()) {
                MDC.put((String)"mdc-var", (String)(currentLabel + aspLogValue));
            } else {
                AspectLogContext.putLogValue(currentLabel + aspLogValue);
            }
        }
        try {
            Object object = jp.proceed();
            return object;
        }
        finally {
            AspectLogContext.remove();
        }
    }

    private String getExpressionValue(String expression, Object o) {
        int n = 0;
        String[] expressionItems = expression.split("\\.");
        String[] stringArray = expressionItems;
        int n2 = stringArray.length;
        if (n < n2) {
            String item = stringArray[n];
            if (String.class.isAssignableFrom(o.getClass())) {
                return (String)o;
            }
            if (Integer.class.isAssignableFrom(o.getClass())) {
                return ((Integer)o).toString();
            }
            if (Long.class.isAssignableFrom(o.getClass())) {
                return ((Long)o).toString();
            }
            if (Double.class.isAssignableFrom(o.getClass())) {
                return ((Double)o).toString();
            }
            if (BigDecimal.class.isAssignableFrom(o.getClass())) {
                return ((BigDecimal)o).toPlainString();
            }
            if (Date.class.isAssignableFrom(o.getClass())) {
                return DateUtil.formatDate((Date)((Date)o), (Object[])new Object[0]);
            }
            if (Map.class.isAssignableFrom(o.getClass())) {
                Object v = ((Map)o).get(item);
                if (v == null) {
                    return null;
                }
                if (expression.equals(this.getRemainExpression(expression, item))) {
                    v = JSONUtil.toJsonStr(v);
                }
                return this.getExpressionValue(this.getRemainExpression(expression, item), v);
            }
            try {
                Object v = MethodUtils.invokeMethod((Object)o, (String)("get" + item.substring(0, 1).toUpperCase() + item.substring(1)));
                if (v == null) {
                    return null;
                }
                if (expression.equals(this.getRemainExpression(expression, item))) {
                    v = JSONUtil.toJsonStr((Object)v);
                }
                return this.getExpressionValue(this.getRemainExpression(expression, item), v);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private String getRemainExpression(String expression, String expressionItem) {
        if (expression.equals(expressionItem)) {
            return expressionItem;
        }
        return expression.substring(expressionItem.length() + 1);
    }

    private boolean isRemainExpression(String expression, String expressionItem) {
        return expression.equals(expressionItem);
    }
}

