/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.log.configuration;

import io.github.novareseller.log.configuration.LogCommonAutoConfiguration;
import io.github.novareseller.log.configuration.LogPropertyInit;
import io.github.novareseller.log.configuration.property.LogProperty;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@EnableConfigurationProperties(value={LogProperty.class})
@AutoConfigureAfter(value={LogCommonAutoConfiguration.class})
@PropertySource(name="Log Default Properties", value={"classpath:/META-INF/log-default.properties"})
public class LogPropertyConfiguration {
    @Bean
    public LogPropertyInit tLogPropertyInit(LogProperty logProperty) {
        LogPropertyInit logPropertyInit = new LogPropertyInit();
        logPropertyInit.setPattern(logProperty.getPattern());
        logPropertyInit.setEnableInvokeTimePrint(logProperty.enableInvokeTimePrint());
        logPropertyInit.setIdGenerator(logProperty.getIdGenerator());
        logPropertyInit.setMdcEnable(logProperty.getMdcEnable());
        return logPropertyInit;
    }
}

