/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.log.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import io.github.novareseller.log.context.LogContext;
import org.apache.commons.lang3.StringUtils;

public class SpanIdGenerator {
    private static TransmittableThreadLocal<String> currentSpanIdTL = new TransmittableThreadLocal();
    private static TransmittableThreadLocal<Integer> spanIndex = new TransmittableThreadLocal();
    private static String INITIAL_VALUE = "0";

    public static void putSpanId(String spanId) {
        if (StringUtils.isBlank((CharSequence)spanId)) {
            spanId = INITIAL_VALUE;
        }
        currentSpanIdTL.set((Object)spanId);
        spanIndex.set((Object)Integer.valueOf(INITIAL_VALUE));
    }

    public static String getSpanId() {
        return (String)currentSpanIdTL.get();
    }

    public static void removeSpanId() {
        currentSpanIdTL.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateNextSpanId() {
        String string = LogContext.getTraceId();
        synchronized (string) {
            String currentSpanId = LogContext.getSpanId();
            spanIndex.set((Object)((Integer)spanIndex.get() + 1));
            String nextSpanId = String.format("%s.%s", currentSpanId, spanIndex.get());
            return nextSpanId;
        }
    }
}

