/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.security.config;

import io.github.novareseller.security.properties.JwtProperties;
import io.github.novareseller.tool.utils.SystemClock;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StopWatch;

@Configuration
@EnableConfigurationProperties(value={JwtProperties.class})
public class TenantJwtBuilder {
    private static final Logger log = LoggerFactory.getLogger(TenantJwtBuilder.class);
    @Autowired
    private JwtProperties jwtProperties;

    public String createToken(long tenantId, long uid, int type, String account) {
        long now = SystemClock.now();
        Date date = new Date(now);
        JwtBuilder builder = Jwts.builder().setHeaderParam("type", (Object)"JWT").setIssuedAt(date).setIssuer(String.valueOf(tenantId)).setSubject(String.valueOf(uid)).claim("type", (Object)type).claim("account", (Object)account).signWith(SignatureAlgorithm.forName((String)this.jwtProperties.getAlgorithm()), TenantJwtBuilder.secretKey());
        if (this.jwtProperties.getTtl() >= 0L) {
            builder.setExpiration(new Date(now + 1000L * this.jwtProperties.getTtl()));
        }
        String compact = builder.compact();
        log.info("createToken complete. tenantId={}, uid={}, token={}", new Object[]{tenantId, uid, compact});
        return compact;
    }

    public Claims parseTokenClaims(String tokenValue) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        StopWatch stopWatch = null;
        if (this.jwtProperties.isParseDebug()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        Claims claims = (Claims)Jwts.parser().setSigningKey("3a34e26a61c034d5ec8245d8677df7fc".getBytes()).parseClaimsJws(tokenValue).getBody();
        if (this.jwtProperties.isParseDebug()) {
            stopWatch.stop();
            stopWatch.getTotalTimeMillis();
            log.debug("Token parsing time-consuming: {} millis. Parsed claims={}", (Object)stopWatch.getTotalTimeMillis(), (Object)claims);
        }
        return claims;
    }

    public static byte[] secretKey() {
        byte[] bytes;
        try {
            bytes = "3a34e26a61c034d5ec8245d8677df7fc".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        return bytes;
    }
}

