/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.security.helper;

import io.github.novareseller.tool.utils.SystemClock;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthorizationHelper {
    private static final Logger log = LoggerFactory.getLogger(ClientAuthorizationHelper.class);
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final byte[] EMPTY_ARRAY = new byte[0];

    private static String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] createFormData(Map<String, String> form) {
        if (form == null || form.isEmpty()) {
            return EMPTY_ARRAY;
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>(form);
        String text = sorted.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), ClientAuthorizationHelper.urlEncode((String)entry.getValue()))).collect(Collectors.joining("&"));
        return text.getBytes(StandardCharsets.UTF_8);
    }

    public static String createAuthorization(long timestamp, String appId, String secretKey, byte[] data) throws Exception {
        Objects.requireNonNull(appId);
        Objects.requireNonNull(secretKey);
        Objects.requireNonNull(data);
        String algorithm = HMAC_ALGORITHM;
        byte[] sign = ClientAuthorizationHelper.sign(timestamp, appId, secretKey, data, algorithm);
        return String.format("%s;%d;%s;%s", algorithm, timestamp, appId, Base64.encodeBase64URLSafeString((byte[])sign));
    }

    public static String createAuthorization(long timestamp, String appId, String secretKey, String body) throws Exception {
        byte[] data = body == null ? EMPTY_ARRAY : body.getBytes(StandardCharsets.UTF_8);
        return ClientAuthorizationHelper.createAuthorization(timestamp, appId, secretKey, data);
    }

    public static boolean verifyAuthorization(String appId, String secretKey, byte[] data, String authorization) throws Exception {
        if (appId == null || secretKey == null || data == null || authorization == null) {
            return false;
        }
        AuthorizationInfo info = ClientAuthorizationHelper.parse(authorization);
        if (info == null) {
            log.warn("Invalid authorization format: authorization={}", (Object)authorization);
            return false;
        }
        if (!appId.equals(info.appId)) {
            log.warn("Appid mismatch: authorization={}, appid={}", (Object)authorization, (Object)appId);
            return false;
        }
        return info.verify(data, secretKey);
    }

    public static boolean verifyAuthorization(String appId, String secretKey, String body, String authorization) throws Exception {
        byte[] data = body == null ? EMPTY_ARRAY : body.getBytes(StandardCharsets.UTF_8);
        return ClientAuthorizationHelper.verifyAuthorization(appId, secretKey, data, authorization);
    }

    private static byte[] sign(long timestamp, String appId, String secretKey, byte[] data, String algorithm) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            dout.writeLong(timestamp);
            dout.write(appId.getBytes(StandardCharsets.UTF_8));
            dout.write(data);
            dout.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Mac mac = HmacUtils.getInitializedMac((String)algorithm, (byte[])secretKey.getBytes(StandardCharsets.UTF_8));
        return mac.doFinal(bout.toByteArray());
    }

    public static AuthorizationInfo parse(String authorization) {
        String[] parts = authorization.split(";");
        if (parts.length != 4) {
            return null;
        }
        AuthorizationInfo info = new AuthorizationInfo();
        info.setAuthorization(authorization);
        info.setAlgorithm(parts[0]);
        info.setAppId(parts[2]);
        info.setTimestamp(Long.parseLong(parts[1]));
        info.setSignature(Base64.decodeBase64((String)parts[3]));
        return info;
    }

    public static class AuthorizationInfo {
        private String appId;
        private long timestamp;
        private byte[] signature;
        private String algorithm;
        private String authorization;

        private AuthorizationInfo() {
        }

        public String getAppId() {
            return this.appId;
        }

        private void setAppId(String appId) {
            this.appId = appId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        private void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        private void setSignature(byte[] signature) {
            this.signature = signature;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        private void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getAuthorization() {
            return this.authorization;
        }

        private void setAuthorization(String authorization) {
            this.authorization = authorization;
        }

        public boolean verify(byte[] data, String secretKey) {
            long valid = 300000L;
            if (SystemClock.now() - this.timestamp > valid) {
                log.warn("Authorization expired: authorization={}", (Object)this.authorization);
                return false;
            }
            byte[] s = ClientAuthorizationHelper.sign(this.timestamp, String.valueOf(this.appId), secretKey, data, this.algorithm);
            return Arrays.equals(s, this.signature);
        }
    }
}

