/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.tool.date;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM", "yyyyMM"};

    public static Date now() {
        return new Date();
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtil.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String defFormat(Date date) {
        return DateUtil.formatDate(date, "yyyy-MM-dd");
    }

    public static String formatDate(Date date, Object ... pattern) {
        String formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        return formatDate;
    }

    public static String getYear() {
        return DateUtil.formatDate(new Date(), "yyyy");
    }

    public static String getYear(Date date) {
        return DateUtil.formatDate(date, "yyyy");
    }

    public static String getMonth() {
        return DateUtil.formatDate(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtil.formatDate(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtil.formatDate(new Date(), "E");
    }
}

