/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.tool.utils;

import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtil {
    private static final char[] C1 = "0123456789".toCharArray();
    private static final char[] C2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] C4 = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final Random random = new Random(System.currentTimeMillis() ^ 0xAA1EACB8AAE1C438L);
    public static final int DIGIT = 1;
    public static final int UPPER_CASE = 2;
    public static final int LOWER_CASE = 4;

    private static String getString(char[] raw, int length, Random random) {
        char[] array = new char[length];
        while (length-- > 0) {
            array[length] = raw[random.nextInt(raw.length)];
        }
        return new String(array);
    }

    private static String getString(char[] raw, int length) {
        return RandomUtil.getString(raw, length, random);
    }

    private static char[] getCharArray(int type) {
        StringBuilder sb = new StringBuilder();
        if ((type & 1) != 0) {
            sb.append(C1);
        }
        if ((type & 2) != 0) {
            sb.append(C2);
        }
        if ((type & 4) != 0) {
            sb.append(C4);
        }
        return sb.toString().toCharArray();
    }

    public static String getString(int length, int type) {
        char[] raw = RandomUtil.getCharArray(type);
        return RandomUtil.getString(raw, length);
    }

    public static String getString(int length) {
        return RandomUtil.getString(length, 7);
    }

    public static int getNumber() {
        return random.nextInt(Integer.MAX_VALUE);
    }

    public static int getNumber(int max) {
        return random.nextInt(max);
    }

    public static byte[] getBytes(int length) {
        byte[] data = new byte[length];
        random.nextBytes(data);
        return data;
    }

    public static String getLocalString(int length) {
        return RandomUtil.getLocalString(length, 7);
    }

    public static String getLocalString(int length, int type) {
        char[] raw = RandomUtil.getCharArray(type);
        return RandomUtil.getString(raw, length, ThreadLocalRandom.current());
    }

    public static String randomUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return new UUID(random.nextLong(), random.nextLong()).toString().replace("-", "");
    }

    static {
        random.nextInt();
    }
}

