/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.tool.collection;

import io.github.novareseller.tool.utils.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class CollectionUtil {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public static <E> ArrayList<E> newArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> LinkedList<E> createLinkedList() {
        return new LinkedList();
    }

    public static <K, V> HashMap<K, V> createHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <F, T> List<T> transform(Collection<F> fromList, Function<? super F, ? extends T> function) {
        if (CollectionUtil.isEmpty(fromList)) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(fromList.size());
        for (F f : fromList) {
            T t = function.apply(f);
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <F> void dispose(Collection<F> fromList, Consumer<? super F> consumer) {
        if (CollectionUtil.isEmpty(fromList)) {
            return;
        }
        for (F f : fromList) {
            if (Validator.isNullOrEmpty(f)) continue;
            consumer.accept(f);
        }
    }

    public static <T, R> List<R> searchValueToList(Collection<T> formList, Predicate<? super T> condition, Function<? super T, ? extends R> function) {
        if (Validator.isNullOrEmpty(formList)) {
            return Collections.emptyList();
        }
        ArrayList<R> result = new ArrayList<R>();
        for (T originalElement : formList) {
            if (originalElement == null || !condition.test(originalElement)) continue;
            R r = function.apply(originalElement);
            result.add(r);
        }
        return result;
    }

    public static <F> List<F> unaryTransform(Collection<F> fromList, UnaryOperator<F> function) {
        if (CollectionUtil.isEmpty(fromList)) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(fromList.size());
        for (F f0 : fromList) {
            Object f1 = function.apply(f0);
            if (f1 == null) continue;
            result.add(f1);
        }
        return result;
    }
}

