/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.timelimiter.monitoring.endpoint;

import io.github.resilience4j.common.timelimiter.monitoring.endpoint.TimeLimiterEventDTO;
import io.github.resilience4j.common.timelimiter.monitoring.endpoint.TimeLimiterEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="timelimiterevents")
public class TimeLimiterEventsEndpoint {
    private final EventConsumerRegistry<TimeLimiterEvent> eventsConsumerRegistry;

    public TimeLimiterEventsEndpoint(EventConsumerRegistry<TimeLimiterEvent> eventsConsumerRegistry) {
        this.eventsConsumerRegistry = eventsConsumerRegistry;
    }

    @ReadOperation
    public TimeLimiterEventsEndpointResponse getAllTimeLimiterEvents() {
        return new TimeLimiterEventsEndpointResponse(this.eventsConsumerRegistry.getAllEventConsumer().stream().flatMap(CircularEventConsumer::getBufferedEventsStream).sorted(Comparator.comparing(TimeLimiterEvent::getCreationTime)).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public TimeLimiterEventsEndpointResponse getEventsFilteredByTimeLimiterName(@Selector String name) {
        return new TimeLimiterEventsEndpointResponse(this.getTimeLimiterEvents(name).stream().map(TimeLimiterEventDTO::createTimeLimiterEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public TimeLimiterEventsEndpointResponse getEventsFilteredByTimeLimiterNameAndEventType(@Selector String name, @Selector String eventType) {
        TimeLimiterEvent.Type targetType = TimeLimiterEvent.Type.valueOf((String)eventType.toUpperCase());
        return new TimeLimiterEventsEndpointResponse(this.getTimeLimiterEvents(name).stream().filter(event -> event.getEventType() == targetType).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).collect(Collectors.toList()));
    }

    private List<TimeLimiterEvent> getTimeLimiterEvents(String name) {
        CircularEventConsumer eventConsumer = this.eventsConsumerRegistry.getEventConsumer(name);
        if (eventConsumer != null) {
            return eventConsumer.getBufferedEventsStream().filter(event -> event.getTimeLimiterName().equals(name)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

