/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.parser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.github.yedaxia.apidocs.ApiDoc;
import io.github.yedaxia.apidocs.DocContext;
import io.github.yedaxia.apidocs.Ignore;
import io.github.yedaxia.apidocs.ParseUtils;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.consts.ChangeFlag;
import io.github.yedaxia.apidocs.parser.ClassNode;
import io.github.yedaxia.apidocs.parser.ControllerNode;
import io.github.yedaxia.apidocs.parser.GenericNode;
import io.github.yedaxia.apidocs.parser.ParamNode;
import io.github.yedaxia.apidocs.parser.RequestNode;
import io.github.yedaxia.apidocs.parser.ResponseNode;
import java.io.File;
import java.util.List;

public abstract class AbsControllerParser {
    private CompilationUnit compilationUnit;
    private ControllerNode controllerNode;
    private File javaFile;

    public ControllerNode parse(File javaFile) {
        this.javaFile = javaFile;
        this.compilationUnit = ParseUtils.compilationUnit(javaFile);
        this.controllerNode = new ControllerNode();
        String controllerName = Utils.getJavaFileName(javaFile);
        this.controllerNode.setClassName(controllerName);
        this.compilationUnit.getClassByName(controllerName).ifPresent(c -> {
            this.beforeHandleController(this.controllerNode, (ClassOrInterfaceDeclaration)c);
            this.parseClassDoc((ClassOrInterfaceDeclaration)c);
            this.parseMethodDocs((ClassOrInterfaceDeclaration)c);
            this.afterHandleController(this.controllerNode, (ClassOrInterfaceDeclaration)c);
        });
        return this.controllerNode;
    }

    File getControllerFile() {
        return this.javaFile;
    }

    ControllerNode getControllerNode() {
        return this.controllerNode;
    }

    private void parseClassDoc(ClassOrInterfaceDeclaration c) {
        ((Node)c.getParentNode().get()).findFirst(PackageDeclaration.class).ifPresent(pd -> this.controllerNode.setPackageName(pd.getNameAsString()));
        boolean generateDocs = c.getAnnotationByName("ApiDoc").isPresent();
        this.controllerNode.setGenerateDocs(generateDocs);
        c.getJavadoc().ifPresent(d -> {
            String description = d.getDescription().toText();
            this.controllerNode.setDescription(Utils.isNotEmpty(description) ? description : c.getNameAsString());
            List blockTags = d.getBlockTags();
            if (blockTags != null) {
                for (JavadocBlockTag blockTag : blockTags) {
                    if ("author".equalsIgnoreCase(blockTag.getTagName())) {
                        this.controllerNode.setAuthor(blockTag.getContent().toText());
                    }
                    if (!"description".equalsIgnoreCase(blockTag.getTagName())) continue;
                    this.controllerNode.setDescription(blockTag.getContent().toText());
                }
            }
        });
        if (this.controllerNode.getDescription() == null) {
            this.controllerNode.setDescription(c.getNameAsString());
        }
    }

    private void parseMethodDocs(ClassOrInterfaceDeclaration c) {
        c.findAll(MethodDeclaration.class).stream().filter(m -> m.getModifiers().contains(Modifier.PUBLIC)).forEach(m -> {
            boolean existsApiDoc = m.getAnnotationByName(ApiDoc.class.getSimpleName()).isPresent();
            if (!(existsApiDoc || this.controllerNode.getGenerateDocs().booleanValue() || DocContext.getDocsConfig().getAutoGenerate().booleanValue())) {
                return;
            }
            if (this.shouldIgnoreMethod((MethodDeclaration)m)) {
                return;
            }
            RequestNode requestNode = new RequestNode();
            requestNode.setControllerNode(this.controllerNode);
            requestNode.setAuthor(this.controllerNode.getAuthor());
            requestNode.setMethodName(m.getNameAsString());
            requestNode.setUrl(requestNode.getMethodName());
            requestNode.setDescription(requestNode.getMethodName());
            m.getAnnotationByClass(Deprecated.class).ifPresent(f -> requestNode.setDeprecated(true));
            m.getJavadoc().ifPresent(d -> {
                String description = d.getDescription().toText();
                requestNode.setDescription(description);
                List blockTagList = d.getBlockTags();
                for (JavadocBlockTag blockTag : blockTagList) {
                    if (blockTag.getTagName().equalsIgnoreCase("param")) {
                        ParamNode paramNode = new ParamNode();
                        if (blockTag.getName().isPresent()) {
                            paramNode.setName((String)blockTag.getName().get());
                        }
                        paramNode.setDescription(blockTag.getContent().toText());
                        requestNode.addParamNode(paramNode);
                        continue;
                    }
                    if (blockTag.getTagName().equalsIgnoreCase("author")) {
                        requestNode.setAuthor(blockTag.getContent().toText());
                        continue;
                    }
                    if (!blockTag.getTagName().equalsIgnoreCase("description")) continue;
                    requestNode.setSupplement(blockTag.getContent().toText());
                }
            });
            m.getParameters().forEach(p -> {
                String paraName = p.getName().asString();
                ParamNode paramNode = requestNode.getParamNodeByName(paraName);
                if (paramNode != null && ParseUtils.isExcludeParam(p)) {
                    requestNode.getParamNodes().remove(paramNode);
                    return;
                }
                if (paramNode != null) {
                    Type pType = p.getType();
                    boolean isList = false;
                    if (pType instanceof ArrayType) {
                        isList = true;
                        pType = ((ArrayType)pType).getComponentType();
                    } else if (ParseUtils.isCollectionType(pType.asString())) {
                        List collectionTypes = pType.getChildNodesByType(ClassOrInterfaceType.class);
                        isList = true;
                        if (!collectionTypes.isEmpty()) {
                            pType = (Type)collectionTypes.get(0);
                        } else {
                            paramNode.setType("Object[]");
                        }
                    } else {
                        pType = p.getType();
                    }
                    if (paramNode.getType() == null) {
                        if (ParseUtils.isEnum(this.getControllerFile(), pType.asString())) {
                            paramNode.setType(isList ? "enum[]" : "enum");
                        } else {
                            String pUnifyType = ParseUtils.unifyType(pType.asString());
                            paramNode.setType(isList ? pUnifyType + "[]" : pUnifyType);
                        }
                    }
                }
            });
            Type resultClassType = null;
            String stringResult = null;
            if (existsApiDoc) {
                AnnotationExpr an = (AnnotationExpr)m.getAnnotationByName("ApiDoc").get();
                if (an instanceof SingleMemberAnnotationExpr) {
                    resultClassType = ((ClassExpr)((SingleMemberAnnotationExpr)an).getMemberValue()).getType();
                } else if (an instanceof NormalAnnotationExpr) {
                    for (MemberValuePair pair : ((NormalAnnotationExpr)an).getPairs()) {
                        String pairName = pair.getNameAsString();
                        if ("result".equals(pairName) || "value".equals(pairName)) {
                            resultClassType = ((ClassExpr)pair.getValue()).getType();
                            continue;
                        }
                        if (pairName.equals("url")) {
                            requestNode.setUrl(((StringLiteralExpr)pair.getValue()).getValue());
                            continue;
                        }
                        if (pairName.equals("method")) {
                            requestNode.addMethod(((StringLiteralExpr)pair.getValue()).getValue());
                            continue;
                        }
                        if (!"stringResult".equals(pairName)) continue;
                        stringResult = ((StringLiteralExpr)pair.getValue()).getValue();
                    }
                }
            }
            this.afterHandleMethod(requestNode, (MethodDeclaration)m);
            if (resultClassType == null) {
                if (m.getType() == null) {
                    return;
                }
                resultClassType = m.getType();
            }
            ResponseNode responseNode = new ResponseNode();
            responseNode.setRequestNode(requestNode);
            if (stringResult != null) {
                responseNode.setStringResult(stringResult);
            } else {
                this.handleResponseNode(responseNode, resultClassType.getElementType());
            }
            requestNode.setResponseNode(responseNode);
            this.setRequestNodeChangeFlag(requestNode);
            this.controllerNode.addRequestNode(requestNode);
        });
    }

    protected void beforeHandleController(ControllerNode controllerNode, ClassOrInterfaceDeclaration clazz) {
    }

    protected void afterHandleController(ControllerNode controllerNode, ClassOrInterfaceDeclaration clazz) {
    }

    protected boolean shouldIgnoreMethod(MethodDeclaration m) {
        return m.getAnnotationByName(Ignore.class.getSimpleName()).isPresent();
    }

    protected void handleResponseNode(ResponseNode responseNode, Type resultType) {
        this.parseClassNodeByType(responseNode, resultType);
    }

    void parseClassNodeByType(ClassNode classNode, Type classType) {
        if (classType instanceof ClassOrInterfaceType) {
            ((ClassOrInterfaceType)classType).getTypeArguments().ifPresent(typeList -> typeList.forEach(argType -> {
                GenericNode rootGenericNode = new GenericNode();
                rootGenericNode.setFromJavaFile(this.javaFile);
                rootGenericNode.setClassType((Type)argType);
                classNode.addGenericNode(rootGenericNode);
            }));
            ParseUtils.parseClassNodeByType(this.javaFile, classNode, classType);
        }
    }

    protected void afterHandleMethod(RequestNode requestNode, MethodDeclaration md) {
    }

    private void setRequestNodeChangeFlag(RequestNode requestNode) {
        List<ControllerNode> lastControllerNodeList = DocContext.getLastVersionControllerNodes();
        if (lastControllerNodeList == null || lastControllerNodeList.isEmpty()) {
            return;
        }
        for (ControllerNode lastControllerNode : lastControllerNodeList) {
            for (RequestNode lastRequestNode : lastControllerNode.getRequestNodes()) {
                if (!lastRequestNode.getUrl().equals(requestNode.getUrl())) continue;
                requestNode.setLastRequestNode(lastRequestNode);
                requestNode.setChangeFlag(this.isSameRequestNodes(requestNode, lastRequestNode) ? ChangeFlag.SAME : ChangeFlag.MODIFY);
                return;
            }
        }
        requestNode.setChangeFlag(ChangeFlag.NEW);
    }

    private boolean isSameRequestNodes(RequestNode requestNode, RequestNode lastRequestNode) {
        for (String lastMethod : lastRequestNode.getMethod()) {
            if (requestNode.getMethod().contains(lastMethod)) continue;
            return false;
        }
        return Utils.toJson(requestNode.getParamNodes()).equals(Utils.toJson(lastRequestNode.getParamNodes())) && Utils.toJson(requestNode.getHeader()).equals(Utils.toJson(lastRequestNode.getHeader())) && requestNode.getResponseNode().toJsonApi().equals(lastRequestNode.getResponseNode().toJsonApi());
    }
}

