/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java;

import io.growing.sdk.java.constants.RunMode;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.sender.FixThreadPoolSender;
import io.growing.sdk.java.store.StoreStrategyClient;
import io.growing.sdk.java.utils.ConfigUtils;
import io.growing.sdk.java.utils.VersionInfo;

public class GrowingAPI {
    private static final RunMode runMode = RunMode.getByValue(ConfigUtils.getStringValue("run.mode", "test"));
    private static boolean validDefaultConfig = GrowingAPI.validDefaultConfig();

    private static boolean validDefaultConfig() {
        GioLogger.debug("growingio-java-sdk version is " + VersionInfo.getVersion());
        String projectId = FixThreadPoolSender.getProjectId();
        if (projectId == null || projectId.length() == 0 || projectId.equals("\u586b\u5199\u60a8\u9879\u76ee\u7684AccountID")) {
            GioLogger.error("please set up your project accountID to gio.properties for key [project.id]");
            return false;
        }
        return FixThreadPoolSender.getNetProvider().isConnectedToGrowingAPIHost();
    }

    public static void send(GIOMessage msg) {
        try {
            if (validDefaultConfig) {
                StoreStrategyClient.getStoreInstance().push(msg);
            }
        }
        catch (Exception e) {
            GioLogger.error("failed to send msg, " + e.toString());
        }
    }

    public static RunMode getRunMode() {
        return runMode;
    }

    public static boolean isTestMode() {
        return GrowingAPI.getRunMode() == RunMode.TEST;
    }

    public static boolean isProductionMode() {
        return GrowingAPI.getRunMode() == RunMode.PRODUCTION;
    }
}

