/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.dto;

import io.growing.sdk.java.dto.GIOMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class GIOEventMessage
extends GIOMessage
implements Serializable {
    private static final long serialVersionUID = -5228910337644290100L;
    private static final String tm = "tm";
    private static final String n = "n";
    private static final String num = "num";
    private static final String var = "var";
    private static final String cs1 = "cs1";
    private static final String t = "t";
    private Map<String, Object> mapResult;

    private GIOEventMessage(Builder builder) {
        this.mapResult = builder.builderMap;
        this.mapResult.put(t, "cstm");
        if (this.mapResult.get(tm) == null) {
            this.mapResult.put(tm, System.currentTimeMillis());
        }
    }

    public static Builder newMessage() {
        return new Builder();
    }

    public String getN() {
        Object nValue = this.mapResult.get(n);
        if (nValue instanceof String) {
            return nValue.toString();
        }
        return null;
    }

    public String getCs1() {
        Object cs1Value = this.mapResult.get(cs1);
        if (cs1Value instanceof String) {
            return cs1Value.toString();
        }
        return null;
    }

    @Override
    public Map<String, Object> getMapResult() {
        return this.mapResult;
    }

    public static final class Builder {
        private Map<String, Object> eventVar = new HashMap<String, Object>();
        private Map<String, Object> builderMap = new HashMap<String, Object>();

        public GIOEventMessage build() {
            return new GIOEventMessage(this);
        }

        public Builder eventTime(Long eventTime) {
            this.builderMap.put(GIOEventMessage.tm, eventTime);
            return this;
        }

        public Builder eventKey(String eventKey) {
            this.builderMap.put(GIOEventMessage.n, eventKey);
            return this;
        }

        public Builder loginUserId(String loginUserId) {
            this.builderMap.put(GIOEventMessage.cs1, loginUserId);
            return this;
        }

        public Builder eventNumValue(Number numValue) {
            double value;
            if (numValue != null && (value = numValue.doubleValue()) >= 0.0) {
                this.builderMap.put(GIOEventMessage.num, value);
            }
            return this;
        }

        public Builder addEventVariable(String key, Integer value) {
            this.addEventVariableObject(key, value);
            return this;
        }

        public Builder addEventVariable(String key, Double value) {
            this.addEventVariableObject(key, value);
            return this;
        }

        public Builder addEventVariable(String key, String value) {
            this.addEventVariableObject(key, value);
            return this;
        }

        private Builder addEventVariableObject(String key, Object value) {
            if (key != null) {
                key = key.trim();
                if (value instanceof String) {
                    String val = value.toString();
                    if (val.length() > 255) {
                        this.eventVar.put(key, val.substring(0, 255));
                    } else {
                        this.eventVar.put(key, value);
                    }
                } else {
                    this.eventVar.put(key, value);
                }
                this.builderMap.put(GIOEventMessage.var, this.eventVar);
            }
            return this;
        }
    }
}

