/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.sender.net;

import io.growing.sdk.java.exception.GIOMessageException;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.sender.net.NetProviderAbstract;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpUrlProvider
extends NetProviderAbstract {
    @Override
    protected void sendPost(String url, byte[] data) {
        try {
            this.doSend(url, data);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                this.retry(url, data);
            }
            GioLogger.error("failed to send growingio data" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendGet(String url) throws IOException {
        HttpURLConnection httpConn = this.getConnection(url);
        this.setHeaders(httpConn);
        httpConn.setRequestMethod("GET");
        httpConn.setConnectTimeout(connectionTimeout);
        httpConn.setReadTimeout(readTimeout);
        InputStream inputStream = null;
        try {
            httpConn.connect();
            int responseCode = httpConn.getResponseCode();
            inputStream = httpConn.getInputStream();
            if (responseCode != 200) {
                throw new GIOMessageException("growingio server return error " + responseCode);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public boolean isConnectedToGrowingAPIHost() {
        try {
            this.sendGet(CHECK_NET_HEALTH_URL);
            return true;
        }
        catch (IOException e) {
            GioLogger.error("failed to connect " + CHECK_NET_HEALTH_URL + ", cause " + e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(String url, byte[] data) throws Exception {
        HttpURLConnection httpConn = this.getConnection(url);
        this.setHeaders(httpConn);
        httpConn.setUseCaches(false);
        httpConn.setRequestMethod("POST");
        httpConn.setConnectTimeout(connectionTimeout);
        httpConn.setReadTimeout(readTimeout);
        httpConn.setRequestProperty("Content-Type", "application/json");
        httpConn.setRequestProperty("Content-Length", String.valueOf(data.length));
        httpConn.setDoOutput(true);
        FilterOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            httpConn.connect();
            outputStream = new DataOutputStream(httpConn.getOutputStream());
            outputStream.write(data);
            ((DataOutputStream)outputStream).flush();
            int responseCode = httpConn.getResponseCode();
            inputStream = httpConn.getInputStream();
            if (responseCode != 200) {
                GioLogger.error("growingio server return error " + responseCode);
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void setHeaders(HttpURLConnection httpConn) {
        for (Map.Entry entry : httpHeaders.entrySet()) {
            httpConn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void retry(String url, byte[] data) {
        int retryTimes = 3;
        for (int i = 0; i < retryTimes; ++i) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                this.doSend(url, data);
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        Proxy proxy = NetProviderAbstract.ProxyInfo.getProxy();
        HttpURLConnection httpConn = proxy == null ? (HttpURLConnection)new URL(url).openConnection() : (HttpURLConnection)new URL(url).openConnection(proxy);
        return httpConn;
    }
}

