/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.tsid;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.Instant;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;

public final class TSID
implements Serializable,
Comparable<TSID> {
    private static final long serialVersionUID = -5446820982139116297L;
    private final long number;
    public static final int TSID_BYTES = 8;
    public static final int TSID_CHARS = 13;
    public static final long TSID_EPOCH = Instant.parse("2020-01-01T00:00:00.000Z").toEpochMilli();
    static final int RANDOM_BITS = 22;
    static final int RANDOM_MASK = 0x3FFFFF;
    private static final char[] ALPHABET_UPPERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] ALPHABET_LOWERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'y', 'z'};
    private static final long[] ALPHABET_VALUES = new long[128];

    public TSID(long number) {
        this.number = number;
    }

    public static TSID from(long number) {
        return new TSID(number);
    }

    public static TSID from(byte[] bytes) {
        if (bytes == null || bytes.length != 8) {
            throw new IllegalArgumentException("Invalid TSID bytes");
        }
        long number = 0L;
        number |= ((long)bytes[0] & 0xFFL) << 56;
        number |= ((long)bytes[1] & 0xFFL) << 48;
        number |= ((long)bytes[2] & 0xFFL) << 40;
        number |= ((long)bytes[3] & 0xFFL) << 32;
        number |= ((long)bytes[4] & 0xFFL) << 24;
        number |= ((long)bytes[5] & 0xFFL) << 16;
        number |= ((long)bytes[6] & 0xFFL) << 8;
        return new TSID(number |= (long)bytes[7] & 0xFFL);
    }

    public static TSID from(String string) {
        char[] chars = TSID.toCharArray(string);
        long number = 0L;
        number |= ALPHABET_VALUES[chars[0]] << 60;
        number |= ALPHABET_VALUES[chars[1]] << 55;
        number |= ALPHABET_VALUES[chars[2]] << 50;
        number |= ALPHABET_VALUES[chars[3]] << 45;
        number |= ALPHABET_VALUES[chars[4]] << 40;
        number |= ALPHABET_VALUES[chars[5]] << 35;
        number |= ALPHABET_VALUES[chars[6]] << 30;
        number |= ALPHABET_VALUES[chars[7]] << 25;
        number |= ALPHABET_VALUES[chars[8]] << 20;
        number |= ALPHABET_VALUES[chars[9]] << 15;
        number |= ALPHABET_VALUES[chars[10]] << 10;
        number |= ALPHABET_VALUES[chars[11]] << 5;
        return new TSID(number |= ALPHABET_VALUES[chars[12]]);
    }

    public long toLong() {
        return this.number;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this.number >>> 56), (byte)(this.number >>> 48), (byte)(this.number >>> 40), (byte)(this.number >>> 32), (byte)(this.number >>> 24), (byte)(this.number >>> 16), (byte)(this.number >>> 8), (byte)this.number};
        return bytes;
    }

    public static TSID fast() {
        long time = System.currentTimeMillis() - TSID_EPOCH << 22;
        long tail = LazyHolder.counter.incrementAndGet() & 0x3FFFFF;
        return new TSID(time | tail);
    }

    public String toString() {
        return this.toString(ALPHABET_UPPERCASE);
    }

    public String toLowerCase() {
        return this.toString(ALPHABET_LOWERCASE);
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.getUnixMilliseconds());
    }

    public Instant getInstant(Instant customEpoch) {
        return Instant.ofEpochMilli(this.getUnixMilliseconds(customEpoch.toEpochMilli()));
    }

    public long getUnixMilliseconds() {
        return this.getTime() + TSID_EPOCH;
    }

    public long getUnixMilliseconds(long customEpoch) {
        return this.getTime() + customEpoch;
    }

    long getTime() {
        return this.number >>> 22;
    }

    long getRandom() {
        return this.number & 0x3FFFFFL;
    }

    public static boolean isValid(String string) {
        return string != null && TSID.isValidCharArray(string.toCharArray());
    }

    public int hashCode() {
        return (int)(this.number ^ this.number >>> 32);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != TSID.class) {
            return false;
        }
        TSID that = (TSID)other;
        return this.number == that.number;
    }

    @Override
    public int compareTo(TSID that) {
        long min = Long.MIN_VALUE;
        long a = this.number + Long.MIN_VALUE;
        long b = that.number + Long.MIN_VALUE;
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public String encode(int base) {
        if (base < 2 || base > 62) {
            throw new IllegalArgumentException(String.format("Invalid base: %s", base));
        }
        return BaseN.encode(this, base);
    }

    public static TSID decode(String string, int base) {
        if (base < 2 || base > 62) {
            throw new IllegalArgumentException(String.format("Invalid base: %s", base));
        }
        return BaseN.decode(string, base);
    }

    public String format(String format) {
        if (format != null) {
            int i = format.indexOf("%");
            if (i < 0 || i == format.length() - 1) {
                throw new IllegalArgumentException(String.format("Invalid format string: \"%s\"", format));
            }
            String head = format.substring(0, i);
            String tail = format.substring(i + 2);
            char placeholder = format.charAt(i + 1);
            switch (placeholder) {
                case 'S': {
                    return head + this.toString() + tail;
                }
                case 's': {
                    return head + this.toLowerCase() + tail;
                }
                case 'X': {
                    return head + BaseN.encode(this, 16) + tail;
                }
                case 'x': {
                    return head + BaseN.encode(this, 16).toLowerCase() + tail;
                }
                case 'd': {
                    return head + BaseN.encode(this, 10) + tail;
                }
                case 'z': {
                    return head + BaseN.encode(this, 62) + tail;
                }
            }
            throw new IllegalArgumentException(String.format("Invalid placeholder: \"%%%s\"", Character.valueOf(placeholder)));
        }
        throw new IllegalArgumentException(String.format("Invalid format string: \"%s\"", format));
    }

    public static TSID unformat(String formatted, String format) {
        if (formatted != null && format != null) {
            int i = format.indexOf("%");
            if (i < 0 || i == format.length() - 1) {
                throw new IllegalArgumentException(String.format("Invalid format string: \"%s\"", format));
            }
            String head = format.substring(0, i);
            String tail = format.substring(i + 2);
            char placeholder = format.charAt(i + 1);
            int length = formatted.length() - head.length() - tail.length();
            if (formatted.startsWith(head) && formatted.endsWith(tail)) {
                switch (placeholder) {
                    case 'S': {
                        return TSID.from(formatted.substring(i, i + length));
                    }
                    case 's': {
                        return TSID.from(formatted.substring(i, i + length));
                    }
                    case 'X': {
                        return BaseN.decode(formatted.substring(i, i + length).toUpperCase(), 16);
                    }
                    case 'x': {
                        return BaseN.decode(formatted.substring(i, i + length).toUpperCase(), 16);
                    }
                    case 'd': {
                        return BaseN.decode(formatted.substring(i, i + length), 10);
                    }
                    case 'z': {
                        return BaseN.decode(formatted.substring(i, i + length), 62);
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid placeholder: \"%%%s\"", Character.valueOf(placeholder)));
            }
        }
        throw new IllegalArgumentException(String.format("Invalid formatted string: \"%s\"", formatted));
    }

    String toString(char[] alphabet) {
        char[] chars = new char[]{alphabet[(int)(this.number >>> 60 & 0x1FL)], alphabet[(int)(this.number >>> 55 & 0x1FL)], alphabet[(int)(this.number >>> 50 & 0x1FL)], alphabet[(int)(this.number >>> 45 & 0x1FL)], alphabet[(int)(this.number >>> 40 & 0x1FL)], alphabet[(int)(this.number >>> 35 & 0x1FL)], alphabet[(int)(this.number >>> 30 & 0x1FL)], alphabet[(int)(this.number >>> 25 & 0x1FL)], alphabet[(int)(this.number >>> 20 & 0x1FL)], alphabet[(int)(this.number >>> 15 & 0x1FL)], alphabet[(int)(this.number >>> 10 & 0x1FL)], alphabet[(int)(this.number >>> 5 & 0x1FL)], alphabet[(int)(this.number & 0x1FL)]};
        return new String(chars);
    }

    static char[] toCharArray(String string) {
        char[] chars;
        char[] cArray = chars = string == null ? null : string.toCharArray();
        if (!TSID.isValidCharArray(chars)) {
            throw new IllegalArgumentException(String.format("Invalid TSID string: \"%s\"", string));
        }
        return chars;
    }

    static boolean isValidCharArray(char[] chars) {
        if (chars == null || chars.length != 13) {
            return false;
        }
        if ((ALPHABET_VALUES[chars[0]] & 0x10L) != 0L) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (ALPHABET_VALUES[chars[i]] != -1L) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < ALPHABET_VALUES.length; ++i) {
            TSID.ALPHABET_VALUES[i] = -1L;
        }
        TSID.ALPHABET_VALUES[48] = 0L;
        TSID.ALPHABET_VALUES[49] = 1L;
        TSID.ALPHABET_VALUES[50] = 2L;
        TSID.ALPHABET_VALUES[51] = 3L;
        TSID.ALPHABET_VALUES[52] = 4L;
        TSID.ALPHABET_VALUES[53] = 5L;
        TSID.ALPHABET_VALUES[54] = 6L;
        TSID.ALPHABET_VALUES[55] = 7L;
        TSID.ALPHABET_VALUES[56] = 8L;
        TSID.ALPHABET_VALUES[57] = 9L;
        TSID.ALPHABET_VALUES[97] = 10L;
        TSID.ALPHABET_VALUES[98] = 11L;
        TSID.ALPHABET_VALUES[99] = 12L;
        TSID.ALPHABET_VALUES[100] = 13L;
        TSID.ALPHABET_VALUES[101] = 14L;
        TSID.ALPHABET_VALUES[102] = 15L;
        TSID.ALPHABET_VALUES[103] = 16L;
        TSID.ALPHABET_VALUES[104] = 17L;
        TSID.ALPHABET_VALUES[106] = 18L;
        TSID.ALPHABET_VALUES[107] = 19L;
        TSID.ALPHABET_VALUES[109] = 20L;
        TSID.ALPHABET_VALUES[110] = 21L;
        TSID.ALPHABET_VALUES[112] = 22L;
        TSID.ALPHABET_VALUES[113] = 23L;
        TSID.ALPHABET_VALUES[114] = 24L;
        TSID.ALPHABET_VALUES[115] = 25L;
        TSID.ALPHABET_VALUES[116] = 26L;
        TSID.ALPHABET_VALUES[118] = 27L;
        TSID.ALPHABET_VALUES[119] = 28L;
        TSID.ALPHABET_VALUES[120] = 29L;
        TSID.ALPHABET_VALUES[121] = 30L;
        TSID.ALPHABET_VALUES[122] = 31L;
        TSID.ALPHABET_VALUES[111] = 0L;
        TSID.ALPHABET_VALUES[105] = 1L;
        TSID.ALPHABET_VALUES[108] = 1L;
        TSID.ALPHABET_VALUES[65] = 10L;
        TSID.ALPHABET_VALUES[66] = 11L;
        TSID.ALPHABET_VALUES[67] = 12L;
        TSID.ALPHABET_VALUES[68] = 13L;
        TSID.ALPHABET_VALUES[69] = 14L;
        TSID.ALPHABET_VALUES[70] = 15L;
        TSID.ALPHABET_VALUES[71] = 16L;
        TSID.ALPHABET_VALUES[72] = 17L;
        TSID.ALPHABET_VALUES[74] = 18L;
        TSID.ALPHABET_VALUES[75] = 19L;
        TSID.ALPHABET_VALUES[77] = 20L;
        TSID.ALPHABET_VALUES[78] = 21L;
        TSID.ALPHABET_VALUES[80] = 22L;
        TSID.ALPHABET_VALUES[81] = 23L;
        TSID.ALPHABET_VALUES[82] = 24L;
        TSID.ALPHABET_VALUES[83] = 25L;
        TSID.ALPHABET_VALUES[84] = 26L;
        TSID.ALPHABET_VALUES[86] = 27L;
        TSID.ALPHABET_VALUES[87] = 28L;
        TSID.ALPHABET_VALUES[88] = 29L;
        TSID.ALPHABET_VALUES[89] = 30L;
        TSID.ALPHABET_VALUES[90] = 31L;
        TSID.ALPHABET_VALUES[79] = 0L;
        TSID.ALPHABET_VALUES[73] = 1L;
        TSID.ALPHABET_VALUES[76] = 1L;
    }

    private static class LazyHolder {
        private static final AtomicInteger counter = new AtomicInteger(new SplittableRandom().nextInt());

        private LazyHolder() {
        }
    }

    static class BaseN {
        private static final BigInteger MAX = BigInteger.valueOf(2L).pow(64);
        private static final String ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

        BaseN() {
        }

        static String encode(TSID tsid, int base) {
            int length;
            BigInteger x = new BigInteger(1, tsid.toBytes());
            BigInteger radix = BigInteger.valueOf(base);
            int b = length = (int)Math.ceil(64.0 / (Math.log(base) / Math.log(2.0)));
            char[] buffer = new char[length];
            while (x.compareTo(BigInteger.ZERO) > 0) {
                BigInteger[] result = x.divideAndRemainder(radix);
                buffer[--b] = ALPHABET.charAt(result[1].intValue());
                x = result[0];
            }
            while (b > 0) {
                buffer[--b] = 48;
            }
            return new String(buffer);
        }

        static TSID decode(String string, int base) {
            BigInteger x = BigInteger.ZERO;
            BigInteger radix = BigInteger.valueOf(base);
            int length = (int)Math.ceil(64.0 / (Math.log(base) / Math.log(2.0)));
            if (string == null) {
                throw new IllegalArgumentException(String.format("Invalid base-%d string: null", base));
            }
            if (string.length() != length) {
                throw new IllegalArgumentException(String.format("Invalid base-%d length: %s", base, string.length()));
            }
            for (int i = 0; i < string.length(); ++i) {
                long plus = ALPHABET.indexOf(string.charAt(i));
                if (plus < 0L || plus >= (long)base) {
                    throw new IllegalArgumentException(String.format("Invalid base-%d character: %s", base, Character.valueOf(string.charAt(i))));
                }
                x = x.multiply(radix).add(BigInteger.valueOf(plus));
            }
            if (x.compareTo(MAX) > 0) {
                throw new IllegalArgumentException(String.format("Invalid base-%d value (overflow): %s", base, x));
            }
            return new TSID(x.longValue());
        }
    }

    public static final class Factory {
        public static final Factory INSTANCE = new Factory();
        public static final Factory INSTANCE_256 = Factory.newInstance256();
        public static final Factory INSTANCE_1024 = Factory.newInstance1024();
        public static final Factory INSTANCE_4096 = Factory.newInstance4096();
        public static final IntSupplier THREAD_LOCAL_RANDOM_FUNCTION = () -> ThreadLocalRandom.current().nextInt();
        private int counter;
        private long lastTime;
        private final int node;
        private final int nodeBits;
        private final int counterBits;
        private final int nodeMask;
        private final int counterMask;
        private final Clock clock;
        private final long customEpoch;
        private final IRandom random;
        private final int randomBytes;
        static final int NODE_BITS_256 = 8;
        static final int NODE_BITS_1024 = 10;
        static final int NODE_BITS_4096 = 12;

        public Factory() {
            this(Factory.builder());
        }

        public Factory(int node) {
            this(Factory.builder().withNode(node));
        }

        private Factory(Builder builder) {
            this.customEpoch = builder.getCustomEpoch();
            this.nodeBits = builder.getNodeBits();
            this.random = builder.getRandom();
            this.clock = builder.getClock();
            this.counterBits = 22 - this.nodeBits;
            this.counterMask = 0x3FFFFF >>> this.nodeBits;
            this.nodeMask = 0x3FFFFF >>> this.counterBits;
            this.randomBytes = (this.counterBits - 1) / 8 + 1;
            this.node = builder.getNode() & this.nodeMask;
            this.lastTime = this.clock.millis();
            this.counter = this.getRandomValue();
        }

        public static Factory newInstance256() {
            return Factory.builder().withNodeBits(8).build();
        }

        public static Factory newInstance256(int node) {
            return Factory.builder().withNodeBits(8).withNode(node).build();
        }

        public static Factory newInstance1024() {
            return Factory.builder().withNodeBits(10).build();
        }

        public static Factory newInstance1024(int node) {
            return Factory.builder().withNodeBits(10).withNode(node).build();
        }

        public static Factory newInstance4096() {
            return Factory.builder().withNodeBits(12).build();
        }

        public static Factory newInstance4096(int node) {
            return Factory.builder().withNodeBits(12).withNode(node).build();
        }

        public TSID generate() {
            long _time = this.getTime() << 22;
            long _node = (long)this.node << this.counterBits;
            long _counter = (long)this.counter & (long)this.counterMask;
            return new TSID(_time | _node | _counter);
        }

        private synchronized long getTime() {
            long time = this.clock.millis();
            if (time <= this.lastTime) {
                ++this.counter;
                int carry = this.counter >>> this.counterBits;
                this.counter &= this.counterMask;
                time = this.lastTime + (long)carry;
            } else {
                this.counter = this.getRandomValue();
            }
            this.lastTime = time;
            return time - this.customEpoch;
        }

        private synchronized int getRandomCounter() {
            if (this.random instanceof ByteRandom) {
                byte[] bytes = this.random.nextBytes(this.randomBytes);
                switch (bytes.length) {
                    case 1: {
                        return bytes[0] & 0xFF & this.counterMask;
                    }
                    case 2: {
                        return ((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF) & this.counterMask;
                    }
                }
                return ((bytes[0] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[2] & 0xFF) & this.counterMask;
            }
            return this.random.nextInt() & this.counterMask;
        }

        private int getRandomValue() {
            int randomCounter = this.getRandomCounter();
            int threadId = (int)Thread.currentThread().getId() % 256 << this.counterBits - 8;
            return threadId | randomCounter >> this.counterBits - 8;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TSID getTsid() {
            return INSTANCE.generate();
        }

        public static TSID getTsid256() {
            return INSTANCE_256.generate();
        }

        public static TSID getTsid1024() {
            return INSTANCE_1024.generate();
        }

        public static TSID getTsid4096() {
            return INSTANCE_4096.generate();
        }

        public static class Builder {
            private Integer node;
            private Integer nodeBits;
            private Long customEpoch;
            private IRandom random;
            private Clock clock;

            public Builder withNode(Integer node) {
                this.node = node;
                return this;
            }

            public Builder withNodeBits(Integer nodeBits) {
                this.nodeBits = nodeBits;
                return this;
            }

            public Builder withCustomEpoch(Instant customEpoch) {
                this.customEpoch = customEpoch.toEpochMilli();
                return this;
            }

            public Builder withRandom(Random random) {
                if (random != null) {
                    this.random = random instanceof SecureRandom ? new ByteRandom(random) : new IntRandom(random);
                }
                return this;
            }

            public Builder withRandomFunction(IntSupplier randomFunction) {
                this.random = new IntRandom(randomFunction);
                return this;
            }

            public Builder withRandomFunction(IntFunction<byte[]> randomFunction) {
                this.random = new ByteRandom(randomFunction);
                return this;
            }

            public Builder withClock(Clock clock) {
                this.clock = clock;
                return this;
            }

            protected Integer getNode() {
                int max = (1 << this.nodeBits) - 1;
                if (this.node == null) {
                    this.node = Settings.getNode() != null ? Settings.getNode() : Integer.valueOf(this.random.nextInt() & max);
                }
                if (this.node < 0 || this.node > max) {
                    throw new IllegalArgumentException(String.format("Node ID out of range [0, %s]: %s", max, this.node));
                }
                return this.node;
            }

            protected Integer getNodeBits() {
                if (this.nodeBits == null) {
                    this.nodeBits = Settings.getNodeCount() != null ? Integer.valueOf((int)Math.ceil(Math.log(Settings.getNodeCount().intValue()) / Math.log(2.0))) : Integer.valueOf(10);
                }
                if (this.nodeBits < 0 || this.nodeBits > 20) {
                    throw new IllegalArgumentException(String.format("Node bits out of range [0, 20]: %s", this.nodeBits));
                }
                return this.nodeBits;
            }

            protected Long getCustomEpoch() {
                if (this.customEpoch == null) {
                    this.customEpoch = TSID_EPOCH;
                }
                return this.customEpoch;
            }

            protected IRandom getRandom() {
                if (this.random == null) {
                    this.withRandom(new SecureRandom());
                }
                return this.random;
            }

            protected Clock getClock() {
                if (this.clock == null) {
                    this.withClock(Clock.systemUTC());
                }
                return this.clock;
            }

            public Factory build() {
                return new Factory(this);
            }
        }

        static interface IRandom {
            public int nextInt();

            public byte[] nextBytes(int var1);
        }

        static class ByteRandom
        implements IRandom {
            private final IntFunction<byte[]> randomFunction;

            public ByteRandom() {
                this(ByteRandom.newRandomFunction(null));
            }

            public ByteRandom(Random random) {
                this(ByteRandom.newRandomFunction(random));
            }

            public ByteRandom(IntFunction<byte[]> randomFunction) {
                this.randomFunction = randomFunction != null ? randomFunction : ByteRandom.newRandomFunction(null);
            }

            @Override
            public int nextInt() {
                int number = 0;
                byte[] bytes = this.randomFunction.apply(4);
                for (int i = 0; i < 4; ++i) {
                    number = number << 8 | bytes[i] & 0xFF;
                }
                return number;
            }

            @Override
            public byte[] nextBytes(int length) {
                return this.randomFunction.apply(length);
            }

            protected static IntFunction<byte[]> newRandomFunction(Random random) {
                Random entropy = random != null ? random : new SecureRandom();
                return length -> {
                    byte[] bytes = new byte[length];
                    entropy.nextBytes(bytes);
                    return bytes;
                };
            }
        }

        static class Settings {
            static final String NODE = "tsid.node";
            static final String NODE_COUNT = "tsid.node.count";

            private Settings() {
            }

            public static Integer getNode() {
                return Settings.getPropertyAsInteger(NODE);
            }

            public static Integer getNodeCount() {
                return Settings.getPropertyAsInteger(NODE_COUNT);
            }

            static Integer getPropertyAsInteger(String property) {
                try {
                    return Integer.decode(Settings.getProperty(property));
                }
                catch (NullPointerException | NumberFormatException e) {
                    return null;
                }
            }

            static String getProperty(String name) {
                String property = System.getProperty(name);
                if (property != null && !property.isEmpty()) {
                    return property;
                }
                String variable = System.getenv(name.toUpperCase().replace(".", "_"));
                if (variable != null && !variable.isEmpty()) {
                    return variable;
                }
                return null;
            }
        }

        static class IntRandom
        implements IRandom {
            private final IntSupplier randomFunction;

            public IntRandom() {
                this(IntRandom.newRandomFunction(null));
            }

            public IntRandom(Random random) {
                this(IntRandom.newRandomFunction(random));
            }

            public IntRandom(IntSupplier randomFunction) {
                this.randomFunction = randomFunction != null ? randomFunction : IntRandom.newRandomFunction(null);
            }

            @Override
            public int nextInt() {
                return this.randomFunction.getAsInt();
            }

            @Override
            public byte[] nextBytes(int length) {
                int shift = 0;
                long random = 0L;
                byte[] bytes = new byte[length];
                for (int i = 0; i < length; ++i) {
                    if (shift < 8) {
                        shift = 32;
                        random = this.randomFunction.getAsInt();
                    }
                    bytes[i] = (byte)(random >>> (shift -= 8));
                }
                return bytes;
            }

            protected static IntSupplier newRandomFunction(Random random) {
                Random entropy = random != null ? random : new SecureRandom();
                return entropy::nextInt;
            }
        }
    }
}

