/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.query;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStackTraceLogger
implements StatementInspector {
    public static final String ORG_HIBERNATE = "org.hibernate";
    public static String TAB = "\t";
    public static String NEW_LINE = System.getProperty("line.separator");
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryStackTraceLogger.class);
    private final String packageNamePrefix;

    public QueryStackTraceLogger(String packageNamePrefix) {
        this.packageNamePrefix = packageNamePrefix;
    }

    public String inspect(String sql) {
        LOGGER.debug("This SQL query: [\n\t{}\n]\nwas generated by Hibernate like this: [\n{}\n]", (Object)sql, (Object)String.join((CharSequence)NEW_LINE, this.stackTraceElementsUpTo(this.packageNamePrefix).stream().map(e -> TAB + e.toString()).collect(Collectors.toList())));
        return null;
    }

    private List<StackTraceElement> stackTraceElementsUpTo(String endPackageNamePrefix) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        ArrayList<StackTraceElement> filteredStackTraceElements = new ArrayList<StackTraceElement>();
        boolean startPackageMatched = false;
        boolean endPackageMatched = false;
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            String className = stackTraceElement.getClassName();
            if (!startPackageMatched) {
                if (!className.startsWith(ORG_HIBERNATE)) continue;
                startPackageMatched = true;
            }
            if (!className.contains(endPackageNamePrefix)) {
                if (endPackageMatched) break;
                filteredStackTraceElements.add(stackTraceElement);
                continue;
            }
            if (endPackageMatched) continue;
            endPackageMatched = true;
            filteredStackTraceElements.add(stackTraceElement);
        }
        return filteredStackTraceElements;
    }
}

