package io.ipinfo.api.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.ipinfo.api.model.Continent;
import io.ipinfo.api.model.CountryCurrency;
import io.ipinfo.api.model.CountryFlag;

public class Context {
    private static final Map<String, String> countryMap;
    private static final Map<String, CountryFlag> countriesFlags;
    private static final Map<String, CountryCurrency> countriesCurrencies;
    private static final Map<String, Continent> continents;
    private static final List<String> euCountries;
    private final static String CountryFlagURL = "https://cdn.ipinfo.io/static/images/countries-flags/";

    static {
        Map<String, String> tempCountryMap = new HashMap<>();

        tempCountryMap.put("BD", "Bangladesh");
        tempCountryMap.put("BE", "Belgium");
        tempCountryMap.put("BF", "Burkina Faso");
        tempCountryMap.put("BG", "Bulgaria");
        tempCountryMap.put("BA", "Bosnia and Herzegovina");
        tempCountryMap.put("BB", "Barbados");
        tempCountryMap.put("WF", "Wallis and Futuna");
        tempCountryMap.put("BL", "Saint Barthelemy");
        tempCountryMap.put("BM", "Bermuda");
        tempCountryMap.put("BN", "Brunei");
        tempCountryMap.put("BO", "Bolivia");
        tempCountryMap.put("BH", "Bahrain");
        tempCountryMap.put("BI", "Burundi");
        tempCountryMap.put("BJ", "Benin");
        tempCountryMap.put("BT", "Bhutan");
        tempCountryMap.put("JM", "Jamaica");
        tempCountryMap.put("BV", "Bouvet Island");
        tempCountryMap.put("BW", "Botswana");
        tempCountryMap.put("WS", "Samoa");
        tempCountryMap.put("BQ", "Bonaire, Saint Eustatius and Saba");
        tempCountryMap.put("BR", "Brazil");
        tempCountryMap.put("BS", "Bahamas");
        tempCountryMap.put("JE", "Jersey");
        tempCountryMap.put("BY", "Belarus");
        tempCountryMap.put("BZ", "Belize");
        tempCountryMap.put("RU", "Russia");
        tempCountryMap.put("RW", "Rwanda");
        tempCountryMap.put("RS", "Serbia");
        tempCountryMap.put("TL", "East Timor");
        tempCountryMap.put("RE", "Reunion");
        tempCountryMap.put("TM", "Turkmenistan");
        tempCountryMap.put("TJ", "Tajikistan");
        tempCountryMap.put("RO", "Romania");
        tempCountryMap.put("TK", "Tokelau");
        tempCountryMap.put("GW", "Guinea-Bissau");
        tempCountryMap.put("GU", "Guam");
        tempCountryMap.put("GT", "Guatemala");
        tempCountryMap.put("GS", "South Georgia and the South Sandwich Islands");
        tempCountryMap.put("GR", "Greece");
        tempCountryMap.put("GQ", "Equatorial Guinea");
        tempCountryMap.put("GP", "Guadeloupe");
        tempCountryMap.put("JP", "Japan");
        tempCountryMap.put("GY", "Guyana");
        tempCountryMap.put("GG", "Guernsey");
        tempCountryMap.put("GF", "French Guiana");
        tempCountryMap.put("GE", "Georgia");
        tempCountryMap.put("GD", "Grenada");
        tempCountryMap.put("GB", "United Kingdom");
        tempCountryMap.put("GA", "Gabon");
        tempCountryMap.put("SV", "El Salvador");
        tempCountryMap.put("GN", "Guinea");
        tempCountryMap.put("GM", "Gambia");
        tempCountryMap.put("GL", "Greenland");
        tempCountryMap.put("GI", "Gibraltar");
        tempCountryMap.put("GH", "Ghana");
        tempCountryMap.put("OM", "Oman");
        tempCountryMap.put("TN", "Tunisia");
        tempCountryMap.put("JO", "Jordan");
        tempCountryMap.put("HR", "Croatia");
        tempCountryMap.put("HT", "Haiti");
        tempCountryMap.put("HU", "Hungary");
        tempCountryMap.put("HK", "Hong Kong");
        tempCountryMap.put("HN", "Honduras");
        tempCountryMap.put("HM", "Heard Island and McDonald Islands");
        tempCountryMap.put("VE", "Venezuela");
        tempCountryMap.put("PR", "Puerto Rico");
        tempCountryMap.put("PS", "Palestinian Territory");
        tempCountryMap.put("PW", "Palau");
        tempCountryMap.put("PT", "Portugal");
        tempCountryMap.put("SJ", "Svalbard and Jan Mayen");
        tempCountryMap.put("PY", "Paraguay");
        tempCountryMap.put("IQ", "Iraq");
        tempCountryMap.put("PA", "Panama");
        tempCountryMap.put("PF", "French Polynesia");
        tempCountryMap.put("PG", "Papua New Guinea");
        tempCountryMap.put("PE", "Peru");
        tempCountryMap.put("PK", "Pakistan");
        tempCountryMap.put("PH", "Philippines");
        tempCountryMap.put("PN", "Pitcairn");
        tempCountryMap.put("PL", "Poland");
        tempCountryMap.put("PM", "Saint Pierre and Miquelon");
        tempCountryMap.put("ZM", "Zambia");
        tempCountryMap.put("EH", "Western Sahara");
        tempCountryMap.put("EE", "Estonia");
        tempCountryMap.put("EG", "Egypt");
        tempCountryMap.put("ZA", "South Africa");
        tempCountryMap.put("EC", "Ecuador");
        tempCountryMap.put("IT", "Italy");
        tempCountryMap.put("VN", "Vietnam");
        tempCountryMap.put("SB", "Solomon Islands");
        tempCountryMap.put("ET", "Ethiopia");
        tempCountryMap.put("SO", "Somalia");
        tempCountryMap.put("ZW", "Zimbabwe");
        tempCountryMap.put("SA", "Saudi Arabia");
        tempCountryMap.put("ES", "Spain");
        tempCountryMap.put("ER", "Eritrea");
        tempCountryMap.put("ME", "Montenegro");
        tempCountryMap.put("MD", "Moldova");
        tempCountryMap.put("MG", "Madagascar");
        tempCountryMap.put("MF", "Saint Martin");
        tempCountryMap.put("MA", "Morocco");
        tempCountryMap.put("MC", "Monaco");
        tempCountryMap.put("UZ", "Uzbekistan");
        tempCountryMap.put("MM", "Myanmar");
        tempCountryMap.put("ML", "Mali");
        tempCountryMap.put("MO", "Macao");
        tempCountryMap.put("MN", "Mongolia");
        tempCountryMap.put("MH", "Marshall Islands");
        tempCountryMap.put("MK", "Macedonia");
        tempCountryMap.put("MU", "Mauritius");
        tempCountryMap.put("MT", "Malta");
        tempCountryMap.put("MW", "Malawi");
        tempCountryMap.put("MV", "Maldives");
        tempCountryMap.put("MQ", "Martinique");
        tempCountryMap.put("MP", "Northern Mariana Islands");
        tempCountryMap.put("MS", "Montserrat");
        tempCountryMap.put("MR", "Mauritania");
        tempCountryMap.put("IM", "Isle of Man");
        tempCountryMap.put("UG", "Uganda");
        tempCountryMap.put("TZ", "Tanzania");
        tempCountryMap.put("MY", "Malaysia");
        tempCountryMap.put("MX", "Mexico");
        tempCountryMap.put("IL", "Israel");
        tempCountryMap.put("FR", "France");
        tempCountryMap.put("IO", "British Indian Ocean Territory");
        tempCountryMap.put("SH", "Saint Helena");
        tempCountryMap.put("FI", "Finland");
        tempCountryMap.put("FJ", "Fiji");
        tempCountryMap.put("FK", "Falkland Islands");
        tempCountryMap.put("FM", "Micronesia");
        tempCountryMap.put("FO", "Faroe Islands");
        tempCountryMap.put("NI", "Nicaragua");
        tempCountryMap.put("NL", "Netherlands");
        tempCountryMap.put("NO", "Norway");
        tempCountryMap.put("NA", "Namibia");
        tempCountryMap.put("VU", "Vanuatu");
        tempCountryMap.put("NC", "New Caledonia");
        tempCountryMap.put("NE", "Niger");
        tempCountryMap.put("NF", "Norfolk Island");
        tempCountryMap.put("NG", "Nigeria");
        tempCountryMap.put("NZ", "New Zealand");
        tempCountryMap.put("NP", "Nepal");
        tempCountryMap.put("NR", "Nauru");
        tempCountryMap.put("NU", "Niue");
        tempCountryMap.put("CK", "Cook Islands");
        tempCountryMap.put("XK", "Kosovo");
        tempCountryMap.put("CI", "Ivory Coast");
        tempCountryMap.put("CH", "Switzerland");
        tempCountryMap.put("CO", "Colombia");
        tempCountryMap.put("CN", "China");
        tempCountryMap.put("CM", "Cameroon");
        tempCountryMap.put("CL", "Chile");
        tempCountryMap.put("CC", "Cocos Islands");
        tempCountryMap.put("CA", "Canada");
        tempCountryMap.put("CG", "Republic of the Congo");
        tempCountryMap.put("CF", "Central African Republic");
        tempCountryMap.put("CD", "Democratic Republic of the Congo");
        tempCountryMap.put("CZ", "Czech Republic");
        tempCountryMap.put("CY", "Cyprus");
        tempCountryMap.put("CX", "Christmas Island");
        tempCountryMap.put("CR", "Costa Rica");
        tempCountryMap.put("CW", "Curacao");
        tempCountryMap.put("CV", "Cape Verde");
        tempCountryMap.put("CU", "Cuba");
        tempCountryMap.put("SZ", "Swaziland");
        tempCountryMap.put("SY", "Syria");
        tempCountryMap.put("SX", "Sint Maarten");
        tempCountryMap.put("KG", "Kyrgyzstan");
        tempCountryMap.put("KE", "Kenya");
        tempCountryMap.put("SS", "South Sudan");
        tempCountryMap.put("SR", "Suriname");
        tempCountryMap.put("KI", "Kiribati");
        tempCountryMap.put("KH", "Cambodia");
        tempCountryMap.put("KN", "Saint Kitts and Nevis");
        tempCountryMap.put("KM", "Comoros");
        tempCountryMap.put("ST", "Sao Tome and Principe");
        tempCountryMap.put("SK", "Slovakia");
        tempCountryMap.put("KR", "South Korea");
        tempCountryMap.put("SI", "Slovenia");
        tempCountryMap.put("KP", "North Korea");
        tempCountryMap.put("KW", "Kuwait");
        tempCountryMap.put("SN", "Senegal");
        tempCountryMap.put("SM", "San Marino");
        tempCountryMap.put("SL", "Sierra Leone");
        tempCountryMap.put("SC", "Seychelles");
        tempCountryMap.put("KZ", "Kazakhstan");
        tempCountryMap.put("KY", "Cayman Islands");
        tempCountryMap.put("SG", "Singapore");
        tempCountryMap.put("SE", "Sweden");
        tempCountryMap.put("SD", "Sudan");
        tempCountryMap.put("DO", "Dominican Republic");
        tempCountryMap.put("DM", "Dominica");
        tempCountryMap.put("DJ", "Djibouti");
        tempCountryMap.put("DK", "Denmark");
        tempCountryMap.put("VG", "British Virgin Islands");
        tempCountryMap.put("DE", "Germany");
        tempCountryMap.put("YE", "Yemen");
        tempCountryMap.put("DZ", "Algeria");
        tempCountryMap.put("US", "United States");
        tempCountryMap.put("UY", "Uruguay");
        tempCountryMap.put("YT", "Mayotte");
        tempCountryMap.put("UM", "United States Minor Outlying Islands");
        tempCountryMap.put("LB", "Lebanon");
        tempCountryMap.put("LC", "Saint Lucia");
        tempCountryMap.put("LA", "Laos");
        tempCountryMap.put("TV", "Tuvalu");
        tempCountryMap.put("TW", "Taiwan");
        tempCountryMap.put("TT", "Trinidad and Tobago");
        tempCountryMap.put("TR", "Turkey");
        tempCountryMap.put("LK", "Sri Lanka");
        tempCountryMap.put("LI", "Liechtenstein");
        tempCountryMap.put("LV", "Latvia");
        tempCountryMap.put("TO", "Tonga");
        tempCountryMap.put("LT", "Lithuania");
        tempCountryMap.put("LU", "Luxembourg");
        tempCountryMap.put("LR", "Liberia");
        tempCountryMap.put("LS", "Lesotho");
        tempCountryMap.put("TH", "Thailand");
        tempCountryMap.put("TF", "French Southern Territories");
        tempCountryMap.put("TG", "Togo");
        tempCountryMap.put("TD", "Chad");
        tempCountryMap.put("TC", "Turks and Caicos Islands");
        tempCountryMap.put("LY", "Libya");
        tempCountryMap.put("VA", "Vatican");
        tempCountryMap.put("VC", "Saint Vincent and the Grenadines");
        tempCountryMap.put("AE", "United Arab Emirates");
        tempCountryMap.put("AD", "Andorra");
        tempCountryMap.put("AG", "Antigua and Barbuda");
        tempCountryMap.put("AF", "Afghanistan");
        tempCountryMap.put("AI", "Anguilla");
        tempCountryMap.put("VI", "U.S. Virgin Islands");
        tempCountryMap.put("IS", "Iceland");
        tempCountryMap.put("IR", "Iran");
        tempCountryMap.put("AM", "Armenia");
        tempCountryMap.put("AL", "Albania");
        tempCountryMap.put("AO", "Angola");
        tempCountryMap.put("AQ", "Antarctica");
        tempCountryMap.put("AS", "American Samoa");
        tempCountryMap.put("AR", "Argentina");
        tempCountryMap.put("AU", "Australia");
        tempCountryMap.put("AT", "Austria");
        tempCountryMap.put("AW", "Aruba");
        tempCountryMap.put("IN", "India");
        tempCountryMap.put("AX", "Aland Islands");
        tempCountryMap.put("AZ", "Azerbaijan");
        tempCountryMap.put("IE", "Ireland");
        tempCountryMap.put("ID", "Indonesia");
        tempCountryMap.put("UA", "Ukraine");
        tempCountryMap.put("QA", "Qatar");
        tempCountryMap.put("MZ", "Mozambique");

        countryMap = Collections.unmodifiableMap(tempCountryMap);
    }

    static {
        List<String> tempEuCountries = Arrays.asList(
            "IE", "AT", "LT", "LU", "LV", "DE", "DK", "SE", "SI", "SK", "CZ", "CY", 
            "NL", "FI", "FR", "MT", "ES", "IT", "EE", "PL", "PT", "HU", "HR", "GR", 
            "RO", "BG", "BE"
        );

        euCountries = Collections.unmodifiableList(tempEuCountries);
    }

    static {
        Map<String, CountryFlag> tempCountriesFlags = new HashMap<>();

        tempCountriesFlags.put("AD", new CountryFlag("🇦🇩", "U+1F1E6 U+1F1E9"));
        tempCountriesFlags.put("AE", new CountryFlag("🇦🇪", "U+1F1E6 U+1F1EA"));
        tempCountriesFlags.put("AF", new CountryFlag("🇦🇫", "U+1F1E6 U+1F1EB"));
        tempCountriesFlags.put("AG", new CountryFlag("🇦🇬", "U+1F1E6 U+1F1EC"));
        tempCountriesFlags.put("AI", new CountryFlag("🇦🇮", "U+1F1E6 U+1F1EE"));
        tempCountriesFlags.put("AL", new CountryFlag("🇦🇱", "U+1F1E6 U+1F1F1"));
        tempCountriesFlags.put("AM", new CountryFlag("🇦🇲", "U+1F1E6 U+1F1F2"));
        tempCountriesFlags.put("AO", new CountryFlag("🇦🇴", "U+1F1E6 U+1F1F4"));
        tempCountriesFlags.put("AQ", new CountryFlag("🇦🇶", "U+1F1E6 U+1F1F6"));
        tempCountriesFlags.put("AR", new CountryFlag("🇦🇷", "U+1F1E6 U+1F1F7"));
        tempCountriesFlags.put("AS", new CountryFlag("🇦🇸", "U+1F1E6 U+1F1F8"));
        tempCountriesFlags.put("AT", new CountryFlag("🇦🇹", "U+1F1E6 U+1F1F9"));
        tempCountriesFlags.put("AU", new CountryFlag("🇦🇺", "U+1F1E6 U+1F1FA"));
        tempCountriesFlags.put("AW", new CountryFlag("🇦🇼", "U+1F1E6 U+1F1FC"));
        tempCountriesFlags.put("AX", new CountryFlag("🇦🇽", "U+1F1E6 U+1F1FD"));
        tempCountriesFlags.put("AZ", new CountryFlag("🇦🇿", "U+1F1E6 U+1F1FF"));
        tempCountriesFlags.put("BA", new CountryFlag("🇧🇦", "U+1F1E7 U+1F1E6"));
        tempCountriesFlags.put("BB", new CountryFlag("🇧🇧", "U+1F1E7 U+1F1E7"));
        tempCountriesFlags.put("BD", new CountryFlag("🇧🇩", "U+1F1E7 U+1F1E9"));
        tempCountriesFlags.put("BE", new CountryFlag("🇧🇪", "U+1F1E7 U+1F1EA"));
        tempCountriesFlags.put("BF", new CountryFlag("🇧🇫", "U+1F1E7 U+1F1EB"));
        tempCountriesFlags.put("BG", new CountryFlag("🇧🇬", "U+1F1E7 U+1F1EC"));
        tempCountriesFlags.put("BH", new CountryFlag("🇧🇭", "U+1F1E7 U+1F1ED"));
        tempCountriesFlags.put("BI", new CountryFlag("🇧🇮", "U+1F1E7 U+1F1EE"));
        tempCountriesFlags.put("BJ", new CountryFlag("🇧🇯", "U+1F1E7 U+1F1EF"));
        tempCountriesFlags.put("BL", new CountryFlag("🇧🇱", "U+1F1E7 U+1F1F1"));
        tempCountriesFlags.put("BM", new CountryFlag("🇧🇲", "U+1F1E7 U+1F1F2"));
        tempCountriesFlags.put("BN", new CountryFlag("🇧🇳", "U+1F1E7 U+1F1F3"));
        tempCountriesFlags.put("BO", new CountryFlag("🇧🇴", "U+1F1E7 U+1F1F4"));
        tempCountriesFlags.put("BQ", new CountryFlag("🇧🇶", "U+1F1E7 U+1F1F6"));
        tempCountriesFlags.put("BR", new CountryFlag("🇧🇷", "U+1F1E7 U+1F1F7"));
        tempCountriesFlags.put("BS", new CountryFlag("🇧🇸", "U+1F1E7 U+1F1F8"));
        tempCountriesFlags.put("BT", new CountryFlag("🇧🇹", "U+1F1E7 U+1F1F9"));
        tempCountriesFlags.put("BV", new CountryFlag("🇧🇻", "U+1F1E7 U+1F1FB"));
        tempCountriesFlags.put("BW", new CountryFlag("🇧🇼", "U+1F1E7 U+1F1FC"));
        tempCountriesFlags.put("BY", new CountryFlag("🇧🇾", "U+1F1E7 U+1F1FE"));
        tempCountriesFlags.put("BZ", new CountryFlag("🇧🇿", "U+1F1E7 U+1F1FF"));
        tempCountriesFlags.put("CA", new CountryFlag("🇨🇦", "U+1F1E8 U+1F1E6"));
        tempCountriesFlags.put("CC", new CountryFlag("🇨🇨", "U+1F1E8 U+1F1E8"));
        tempCountriesFlags.put("CD", new CountryFlag("🇨🇩", "U+1F1E8 U+1F1E9"));
        tempCountriesFlags.put("CF", new CountryFlag("🇨🇫", "U+1F1E8 U+1F1EB"));
        tempCountriesFlags.put("CG", new CountryFlag("🇨🇬", "U+1F1E8 U+1F1EC"));
        tempCountriesFlags.put("CH", new CountryFlag("🇨🇭", "U+1F1E8 U+1F1ED"));
        tempCountriesFlags.put("CI", new CountryFlag("🇨🇮", "U+1F1E8 U+1F1EE"));
        tempCountriesFlags.put("CK", new CountryFlag("🇨🇰", "U+1F1E8 U+1F1F0"));
        tempCountriesFlags.put("CL", new CountryFlag("🇨🇱", "U+1F1E8 U+1F1F1"));
        tempCountriesFlags.put("CM", new CountryFlag("🇨🇲", "U+1F1E8 U+1F1F2"));
        tempCountriesFlags.put("CN", new CountryFlag("🇨🇳", "U+1F1E8 U+1F1F3"));
        tempCountriesFlags.put("CO", new CountryFlag("🇨🇴", "U+1F1E8 U+1F1F4"));
        tempCountriesFlags.put("CR", new CountryFlag("🇨🇷", "U+1F1E8 U+1F1F7"));
        tempCountriesFlags.put("CU", new CountryFlag("🇨🇺", "U+1F1E8 U+1F1FA"));
        tempCountriesFlags.put("CV", new CountryFlag("🇨🇻", "U+1F1E8 U+1F1FB"));
        tempCountriesFlags.put("CW", new CountryFlag("🇨🇼", "U+1F1E8 U+1F1FC"));
        tempCountriesFlags.put("CX", new CountryFlag("🇨🇽", "U+1F1E8 U+1F1FD"));
        tempCountriesFlags.put("CY", new CountryFlag("🇨🇾", "U+1F1E8 U+1F1FE"));
        tempCountriesFlags.put("CZ", new CountryFlag("🇨🇿", "U+1F1E8 U+1F1FF"));
        tempCountriesFlags.put("DE", new CountryFlag("🇩🇪", "U+1F1E9 U+1F1EA"));
        tempCountriesFlags.put("DJ", new CountryFlag("🇩🇯", "U+1F1E9 U+1F1EF"));
        tempCountriesFlags.put("DK", new CountryFlag("🇩🇰", "U+1F1E9 U+1F1F0"));
        tempCountriesFlags.put("DM", new CountryFlag("🇩🇲", "U+1F1E9 U+1F1F2"));
        tempCountriesFlags.put("DO", new CountryFlag("🇩🇴", "U+1F1E9 U+1F1F4"));
        tempCountriesFlags.put("DZ", new CountryFlag("🇩🇿", "U+1F1E9 U+1F1FF"));
        tempCountriesFlags.put("EC", new CountryFlag("🇪🇨", "U+1F1EA U+1F1E8"));
        tempCountriesFlags.put("EE", new CountryFlag("🇪🇪", "U+1F1EA U+1F1EA"));
        tempCountriesFlags.put("EG", new CountryFlag("🇪🇬", "U+1F1EA U+1F1EC"));
        tempCountriesFlags.put("EH", new CountryFlag("🇪🇭", "U+1F1EA U+1F1ED"));
        tempCountriesFlags.put("ER", new CountryFlag("🇪🇷", "U+1F1EA U+1F1F7"));
        tempCountriesFlags.put("ES", new CountryFlag("🇪🇸", "U+1F1EA U+1F1F8"));
        tempCountriesFlags.put("ET", new CountryFlag("🇪🇹", "U+1F1EA U+1F1F9"));
        tempCountriesFlags.put("FI", new CountryFlag("🇫🇮", "U+1F1EB U+1F1EE"));
        tempCountriesFlags.put("FJ", new CountryFlag("🇫🇯", "U+1F1EB U+1F1EF"));
        tempCountriesFlags.put("FK", new CountryFlag("🇫🇰", "U+1F1EB U+1F1F0"));
        tempCountriesFlags.put("FM", new CountryFlag("🇫🇲", "U+1F1EB U+1F1F2"));
        tempCountriesFlags.put("FO", new CountryFlag("🇫🇴", "U+1F1EB U+1F1F4"));
        tempCountriesFlags.put("FR", new CountryFlag("🇫🇷", "U+1F1EB U+1F1F7"));
        tempCountriesFlags.put("GA", new CountryFlag("🇬🇦", "U+1F1EC U+1F1E6"));
        tempCountriesFlags.put("GB", new CountryFlag("🇬🇧", "U+1F1EC U+1F1E7"));
        tempCountriesFlags.put("GD", new CountryFlag("🇬🇩", "U+1F1EC U+1F1E9"));
        tempCountriesFlags.put("GE", new CountryFlag("🇬🇪", "U+1F1EC U+1F1EA"));
        tempCountriesFlags.put("GF", new CountryFlag("🇬🇫", "U+1F1EC U+1F1EB"));
        tempCountriesFlags.put("GG", new CountryFlag("🇬🇬", "U+1F1EC U+1F1EC"));
        tempCountriesFlags.put("GH", new CountryFlag("🇬🇭", "U+1F1EC U+1F1ED"));
        tempCountriesFlags.put("GI", new CountryFlag("🇬🇮", "U+1F1EC U+1F1EE"));
        tempCountriesFlags.put("GL", new CountryFlag("🇬🇱", "U+1F1EC U+1F1F1"));
        tempCountriesFlags.put("GM", new CountryFlag("🇬🇲", "U+1F1EC U+1F1F2"));
        tempCountriesFlags.put("GN", new CountryFlag("🇬🇳", "U+1F1EC U+1F1F3"));
        tempCountriesFlags.put("GP", new CountryFlag("🇬🇵", "U+1F1EC U+1F1F5"));
        tempCountriesFlags.put("GQ", new CountryFlag("🇬🇶", "U+1F1EC U+1F1F6"));
        tempCountriesFlags.put("GR", new CountryFlag("🇬🇷", "U+1F1EC U+1F1F7"));
        tempCountriesFlags.put("GS", new CountryFlag("🇬🇸", "U+1F1EC U+1F1F8"));
        tempCountriesFlags.put("GT", new CountryFlag("🇬🇹", "U+1F1EC U+1F1F9"));
        tempCountriesFlags.put("GU", new CountryFlag("🇬🇺", "U+1F1EC U+1F1FA"));
        tempCountriesFlags.put("GW", new CountryFlag("🇬🇼", "U+1F1EC U+1F1FC"));
        tempCountriesFlags.put("GY", new CountryFlag("🇬🇾", "U+1F1EC U+1F1FE"));
        tempCountriesFlags.put("HK", new CountryFlag("🇭🇰", "U+1F1ED U+1F1F0"));
        tempCountriesFlags.put("HM", new CountryFlag("🇭🇲", "U+1F1ED U+1F1F2"));
        tempCountriesFlags.put("HN", new CountryFlag("🇭🇳", "U+1F1ED U+1F1F3"));
        tempCountriesFlags.put("HR", new CountryFlag("🇭🇷", "U+1F1ED U+1F1F7"));
        tempCountriesFlags.put("HT", new CountryFlag("🇭🇹", "U+1F1ED U+1F1F9"));
        tempCountriesFlags.put("HU", new CountryFlag("🇭🇺", "U+1F1ED U+1F1FA"));
        tempCountriesFlags.put("ID", new CountryFlag("🇮🇩", "U+1F1EE U+1F1E9"));
        tempCountriesFlags.put("IE", new CountryFlag("🇮🇪", "U+1F1EE U+1F1EA"));
        tempCountriesFlags.put("IL", new CountryFlag("🇮🇱", "U+1F1EE U+1F1F1"));
        tempCountriesFlags.put("IM", new CountryFlag("🇮🇲", "U+1F1EE U+1F1F2"));
        tempCountriesFlags.put("IN", new CountryFlag("🇮🇳", "U+1F1EE U+1F1F3"));
        tempCountriesFlags.put("IO", new CountryFlag("🇮🇴", "U+1F1EE U+1F1F4"));
        tempCountriesFlags.put("IQ", new CountryFlag("🇮🇶", "U+1F1EE U+1F1F6"));
        tempCountriesFlags.put("IR", new CountryFlag("🇮🇷", "U+1F1EE U+1F1F7"));
        tempCountriesFlags.put("IS", new CountryFlag("🇮🇸", "U+1F1EE U+1F1F8"));
        tempCountriesFlags.put("IT", new CountryFlag("🇮🇹", "U+1F1EE U+1F1F9"));
        tempCountriesFlags.put("JE", new CountryFlag("🇯🇪", "U+1F1EF U+1F1EA"));
        tempCountriesFlags.put("JM", new CountryFlag("🇯🇲", "U+1F1EF U+1F1F2"));
        tempCountriesFlags.put("JO", new CountryFlag("🇯🇴", "U+1F1EF U+1F1F4"));
        tempCountriesFlags.put("JP", new CountryFlag("🇯🇵", "U+1F1EF U+1F1F5"));
        tempCountriesFlags.put("KE", new CountryFlag("🇰🇪", "U+1F1F0 U+1F1EA"));
        tempCountriesFlags.put("KG", new CountryFlag("🇰🇬", "U+1F1F0 U+1F1EC"));
        tempCountriesFlags.put("KH", new CountryFlag("🇰🇭", "U+1F1F0 U+1F1ED"));
        tempCountriesFlags.put("KI", new CountryFlag("🇰🇮", "U+1F1F0 U+1F1EE"));
        tempCountriesFlags.put("KM", new CountryFlag("🇰🇲", "U+1F1F0 U+1F1F2"));
        tempCountriesFlags.put("KN", new CountryFlag("🇰🇳", "U+1F1F0 U+1F1F3"));
        tempCountriesFlags.put("KP", new CountryFlag("🇰🇵", "U+1F1F0 U+1F1F5"));
        tempCountriesFlags.put("KR", new CountryFlag("🇰🇷", "U+1F1F0 U+1F1F7"));
        tempCountriesFlags.put("KW", new CountryFlag("🇰🇼", "U+1F1F0 U+1F1FC"));
        tempCountriesFlags.put("KY", new CountryFlag("🇰🇾", "U+1F1F0 U+1F1FE"));
        tempCountriesFlags.put("KZ", new CountryFlag("🇰🇿", "U+1F1F0 U+1F1FF"));
        tempCountriesFlags.put("LA", new CountryFlag("🇱🇦", "U+1F1F1 U+1F1E6"));
        tempCountriesFlags.put("LB", new CountryFlag("🇱🇧", "U+1F1F1 U+1F1E7"));
        tempCountriesFlags.put("LC", new CountryFlag("🇱🇨", "U+1F1F1 U+1F1E8"));
        tempCountriesFlags.put("LI", new CountryFlag("🇱🇮", "U+1F1F1 U+1F1EE"));
        tempCountriesFlags.put("LK", new CountryFlag("🇱🇰", "U+1F1F1 U+1F1F0"));
        tempCountriesFlags.put("LR", new CountryFlag("🇱🇷", "U+1F1F1 U+1F1F7"));
        tempCountriesFlags.put("LS", new CountryFlag("🇱🇸", "U+1F1F1 U+1F1F8"));
        tempCountriesFlags.put("LT", new CountryFlag("🇱🇹", "U+1F1F1 U+1F1F9"));
        tempCountriesFlags.put("LU", new CountryFlag("🇱🇺", "U+1F1F1 U+1F1FA"));
        tempCountriesFlags.put("LV", new CountryFlag("🇱🇻", "U+1F1F1 U+1F1FB"));
        tempCountriesFlags.put("LY", new CountryFlag("🇱🇾", "U+1F1F1 U+1F1FE"));
        tempCountriesFlags.put("MA", new CountryFlag("🇲🇦", "U+1F1F2 U+1F1E6"));
        tempCountriesFlags.put("MC", new CountryFlag("🇲🇨", "U+1F1F2 U+1F1E8"));
        tempCountriesFlags.put("MD", new CountryFlag("🇲🇩", "U+1F1F2 U+1F1E9"));
        tempCountriesFlags.put("ME", new CountryFlag("🇲🇪", "U+1F1F2 U+1F1EA"));
        tempCountriesFlags.put("MF", new CountryFlag("🇲🇫", "U+1F1F2 U+1F1EB"));
        tempCountriesFlags.put("MG", new CountryFlag("🇲🇬", "U+1F1F2 U+1F1EC"));
        tempCountriesFlags.put("MH", new CountryFlag("🇲🇭", "U+1F1F2 U+1F1ED"));
        tempCountriesFlags.put("MK", new CountryFlag("🇲🇰", "U+1F1F2 U+1F1F0"));
        tempCountriesFlags.put("ML", new CountryFlag("🇲🇱", "U+1F1F2 U+1F1F1"));
        tempCountriesFlags.put("MM", new CountryFlag("🇲🇲", "U+1F1F2 U+1F1F2"));
        tempCountriesFlags.put("MN", new CountryFlag("🇲🇳", "U+1F1F2 U+1F1F3"));
        tempCountriesFlags.put("MO", new CountryFlag("🇲🇴", "U+1F1F2 U+1F1F4"));
        tempCountriesFlags.put("MP", new CountryFlag("🇲🇵", "U+1F1F2 U+1F1F5"));
        tempCountriesFlags.put("MQ", new CountryFlag("🇲🇶", "U+1F1F2 U+1F1F6"));
        tempCountriesFlags.put("MR", new CountryFlag("🇲🇷", "U+1F1F2 U+1F1F7"));
        tempCountriesFlags.put("MS", new CountryFlag("🇲🇸", "U+1F1F2 U+1F1F8"));
        tempCountriesFlags.put("MT", new CountryFlag("🇲🇹", "U+1F1F2 U+1F1F9"));
        tempCountriesFlags.put("MU", new CountryFlag("🇲🇺", "U+1F1F2 U+1F1FA"));
        tempCountriesFlags.put("MV", new CountryFlag("🇲🇻", "U+1F1F2 U+1F1FB"));
        tempCountriesFlags.put("MW", new CountryFlag("🇲🇼", "U+1F1F2 U+1F1FC"));
        tempCountriesFlags.put("MX", new CountryFlag("🇲🇽", "U+1F1F2 U+1F1FD"));
        tempCountriesFlags.put("MY", new CountryFlag("🇲🇾", "U+1F1F2 U+1F1FE"));
        tempCountriesFlags.put("MZ", new CountryFlag("🇲🇿", "U+1F1F2 U+1F1FF"));
        tempCountriesFlags.put("NA", new CountryFlag("🇳🇦", "U+1F1F3 U+1F1E6"));
        tempCountriesFlags.put("NC", new CountryFlag("🇳🇨", "U+1F1F3 U+1F1E8"));
        tempCountriesFlags.put("NE", new CountryFlag("🇳🇪", "U+1F1F3 U+1F1EA"));
        tempCountriesFlags.put("NF", new CountryFlag("🇳🇫", "U+1F1F3 U+1F1EB"));
        tempCountriesFlags.put("NG", new CountryFlag("🇳🇬", "U+1F1F3 U+1F1EC"));
        tempCountriesFlags.put("NI", new CountryFlag("🇳🇮", "U+1F1F3 U+1F1EE"));
        tempCountriesFlags.put("NL", new CountryFlag("🇳🇱", "U+1F1F3 U+1F1F1"));
        tempCountriesFlags.put("NO", new CountryFlag("🇳🇴", "U+1F1F3 U+1F1F4"));
        tempCountriesFlags.put("NP", new CountryFlag("🇳🇵", "U+1F1F3 U+1F1F5"));
        tempCountriesFlags.put("NR", new CountryFlag("🇳🇷", "U+1F1F3 U+1F1F7"));
        tempCountriesFlags.put("NU", new CountryFlag("🇳🇺", "U+1F1F3 U+1F1FA"));
        tempCountriesFlags.put("NZ", new CountryFlag("🇳🇿", "U+1F1F3 U+1F1FF"));
        tempCountriesFlags.put("OM", new CountryFlag("🇴🇲", "U+1F1F4 U+1F1F2"));
        tempCountriesFlags.put("PA", new CountryFlag("🇵🇦", "U+1F1F5 U+1F1E6"));
        tempCountriesFlags.put("PE", new CountryFlag("🇵🇪", "U+1F1F5 U+1F1EA"));
        tempCountriesFlags.put("PF", new CountryFlag("🇵🇫", "U+1F1F5 U+1F1EB"));
        tempCountriesFlags.put("PG", new CountryFlag("🇵🇬", "U+1F1F5 U+1F1EC"));
        tempCountriesFlags.put("PH", new CountryFlag("🇵🇭", "U+1F1F5 U+1F1ED"));
        tempCountriesFlags.put("PK", new CountryFlag("🇵🇰", "U+1F1F5 U+1F1F0"));
        tempCountriesFlags.put("PL", new CountryFlag("🇵🇱", "U+1F1F5 U+1F1F1"));
        tempCountriesFlags.put("PM", new CountryFlag("🇵🇲", "U+1F1F5 U+1F1F2"));
        tempCountriesFlags.put("PN", new CountryFlag("🇵🇳", "U+1F1F5 U+1F1F3"));
        tempCountriesFlags.put("PR", new CountryFlag("🇵🇷", "U+1F1F5 U+1F1F7"));
        tempCountriesFlags.put("PS", new CountryFlag("🇵🇸", "U+1F1F5 U+1F1F8"));
        tempCountriesFlags.put("PT", new CountryFlag("🇵🇹", "U+1F1F5 U+1F1F9"));
        tempCountriesFlags.put("PW", new CountryFlag("🇵🇼", "U+1F1F5 U+1F1FC"));
        tempCountriesFlags.put("PY", new CountryFlag("🇵🇾", "U+1F1F5 U+1F1FE"));
        tempCountriesFlags.put("QA", new CountryFlag("🇶🇦", "U+1F1F6 U+1F1E6"));
        tempCountriesFlags.put("RE", new CountryFlag("🇷🇪", "U+1F1F7 U+1F1EA"));
        tempCountriesFlags.put("RO", new CountryFlag("🇷🇴", "U+1F1F7 U+1F1F4"));
        tempCountriesFlags.put("RS", new CountryFlag("🇷🇸", "U+1F1F7 U+1F1F8"));
        tempCountriesFlags.put("RU", new CountryFlag("🇷🇺", "U+1F1F7 U+1F1FA"));
        tempCountriesFlags.put("RW", new CountryFlag("🇷🇼", "U+1F1F7 U+1F1FC"));
        tempCountriesFlags.put("SA", new CountryFlag("🇸🇦", "U+1F1F8 U+1F1E6"));
        tempCountriesFlags.put("SB", new CountryFlag("🇸🇧", "U+1F1F8 U+1F1E7"));
        tempCountriesFlags.put("SC", new CountryFlag("🇸🇨", "U+1F1F8 U+1F1E8"));
        tempCountriesFlags.put("SD", new CountryFlag("🇸🇩", "U+1F1F8 U+1F1E9"));
        tempCountriesFlags.put("SE", new CountryFlag("🇸🇪", "U+1F1F8 U+1F1EA"));
        tempCountriesFlags.put("SG", new CountryFlag("🇸🇬", "U+1F1F8 U+1F1EC"));
        tempCountriesFlags.put("SH", new CountryFlag("🇸🇭", "U+1F1F8 U+1F1ED"));
        tempCountriesFlags.put("SI", new CountryFlag("🇸🇮", "U+1F1F8 U+1F1EE"));
        tempCountriesFlags.put("SJ", new CountryFlag("🇸🇯", "U+1F1F8 U+1F1EF"));
        tempCountriesFlags.put("SK", new CountryFlag("🇸🇰", "U+1F1F8 U+1F1F0"));
        tempCountriesFlags.put("SL", new CountryFlag("🇸🇱", "U+1F1F8 U+1F1F1"));
        tempCountriesFlags.put("SM", new CountryFlag("🇸🇲", "U+1F1F8 U+1F1F2"));
        tempCountriesFlags.put("SN", new CountryFlag("🇸🇳", "U+1F1F8 U+1F1F3"));
        tempCountriesFlags.put("SO", new CountryFlag("🇸🇴", "U+1F1F8 U+1F1F4"));
        tempCountriesFlags.put("SR", new CountryFlag("🇸🇷", "U+1F1F8 U+1F1F7"));
        tempCountriesFlags.put("SS", new CountryFlag("🇸🇸", "U+1F1F8 U+1F1F8"));
        tempCountriesFlags.put("ST", new CountryFlag("🇸🇹", "U+1F1F8 U+1F1F9"));
        tempCountriesFlags.put("SV", new CountryFlag("🇸🇻", "U+1F1F8 U+1F1FB"));
        tempCountriesFlags.put("SX", new CountryFlag("🇸🇽", "U+1F1F8 U+1F1FD"));
        tempCountriesFlags.put("SY", new CountryFlag("🇸🇾", "U+1F1F8 U+1F1FE"));
        tempCountriesFlags.put("SZ", new CountryFlag("🇸🇿", "U+1F1F8 U+1F1FF"));
        tempCountriesFlags.put("TC", new CountryFlag("🇹🇨", "U+1F1F9 U+1F1E8"));
        tempCountriesFlags.put("TD", new CountryFlag("🇹🇩", "U+1F1F9 U+1F1E9"));
        tempCountriesFlags.put("TF", new CountryFlag("🇹🇫", "U+1F1F9 U+1F1EB"));
        tempCountriesFlags.put("TG", new CountryFlag("🇹🇬", "U+1F1F9 U+1F1EC"));
        tempCountriesFlags.put("TH", new CountryFlag("🇹🇭", "U+1F1F9 U+1F1ED"));
        tempCountriesFlags.put("TJ", new CountryFlag("🇹🇯", "U+1F1F9 U+1F1EF"));
        tempCountriesFlags.put("TK", new CountryFlag("🇹🇰", "U+1F1F9 U+1F1F0"));
        tempCountriesFlags.put("TL", new CountryFlag("🇹🇱", "U+1F1F9 U+1F1F1"));
        tempCountriesFlags.put("TM", new CountryFlag("🇹🇲", "U+1F1F9 U+1F1F2"));
        tempCountriesFlags.put("TN", new CountryFlag("🇹🇳", "U+1F1F9 U+1F1F3"));
        tempCountriesFlags.put("TO", new CountryFlag("🇹🇴", "U+1F1F9 U+1F1F4"));
        tempCountriesFlags.put("TR", new CountryFlag("🇹🇷", "U+1F1F9 U+1F1F7"));
        tempCountriesFlags.put("TT", new CountryFlag("🇹🇹", "U+1F1F9 U+1F1F9"));
        tempCountriesFlags.put("TV", new CountryFlag("🇹🇻", "U+1F1F9 U+1F1FB"));
        tempCountriesFlags.put("TW", new CountryFlag("🇹🇼", "U+1F1F9 U+1F1FC"));
        tempCountriesFlags.put("TZ", new CountryFlag("🇹🇿", "U+1F1F9 U+1F1FF"));
        tempCountriesFlags.put("UA", new CountryFlag("🇺🇦", "U+1F1FA U+1F1E6"));
        tempCountriesFlags.put("UG", new CountryFlag("🇺🇬", "U+1F1FA U+1F1EC"));
        tempCountriesFlags.put("UM", new CountryFlag("🇺🇲", "U+1F1FA U+1F1F2"));
        tempCountriesFlags.put("US", new CountryFlag("🇺🇸", "U+1F1FA U+1F1F8"));
        tempCountriesFlags.put("UY", new CountryFlag("🇺🇾", "U+1F1FA U+1F1FE"));
        tempCountriesFlags.put("UZ", new CountryFlag("🇺🇿", "U+1F1FA U+1F1FF"));
        tempCountriesFlags.put("VA", new CountryFlag("🇻🇦", "U+1F1FB U+1F1E6"));
        tempCountriesFlags.put("VC", new CountryFlag("🇻🇨", "U+1F1FB U+1F1E8"));
        tempCountriesFlags.put("VE", new CountryFlag("🇻🇪", "U+1F1FB U+1F1EA"));
        tempCountriesFlags.put("VG", new CountryFlag("🇻🇬", "U+1F1FB U+1F1EC"));
        tempCountriesFlags.put("VI", new CountryFlag("🇻🇮", "U+1F1FB U+1F1EE"));
        tempCountriesFlags.put("VN", new CountryFlag("🇻🇳", "U+1F1FB U+1F1F3"));
        tempCountriesFlags.put("VU", new CountryFlag("🇻🇺", "U+1F1FB U+1F1FA"));
        tempCountriesFlags.put("WF", new CountryFlag("🇼🇫", "U+1F1FC U+1F1EB"));
        tempCountriesFlags.put("WS", new CountryFlag("🇼🇸", "U+1F1FC U+1F1F8"));
        tempCountriesFlags.put("XK", new CountryFlag("🇽🇰", "U+1F1FD U+1F1F0"));
        tempCountriesFlags.put("YE", new CountryFlag("🇾🇪", "U+1F1FE U+1F1EA"));
        tempCountriesFlags.put("YT", new CountryFlag("🇾🇹", "U+1F1FE U+1F1F9"));
        tempCountriesFlags.put("ZA", new CountryFlag("🇿🇦", "U+1F1FF U+1F1E6"));
        tempCountriesFlags.put("ZM", new CountryFlag("🇿🇲", "U+1F1FF U+1F1F2"));
        tempCountriesFlags.put("ZW", new CountryFlag("🇿🇼", "U+1F1FF U+1F1FC"));

        countriesFlags = Collections.unmodifiableMap(tempCountriesFlags);
    }

    static {
        Map<String, CountryCurrency> tempCountriesCurrencies = new HashMap<>();

        tempCountriesCurrencies.put("AD", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("AE", new CountryCurrency("AED", "د.إ"));
        tempCountriesCurrencies.put("AF", new CountryCurrency("AFN", "؋"));
        tempCountriesCurrencies.put("AG", new CountryCurrency("XCD", "$"));
        tempCountriesCurrencies.put("AI", new CountryCurrency("XCD", "$"));
        tempCountriesCurrencies.put("AL", new CountryCurrency("ALL", "L"));
        tempCountriesCurrencies.put("AM", new CountryCurrency("AMD", "֏"));
        tempCountriesCurrencies.put("AO", new CountryCurrency("AOA", "Kz"));
        tempCountriesCurrencies.put("AQ", new CountryCurrency("", "$"));
        tempCountriesCurrencies.put("AR", new CountryCurrency("ARS", "$"));
        tempCountriesCurrencies.put("AS", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("AT", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("AU", new CountryCurrency("AUD", "$"));
        tempCountriesCurrencies.put("AW", new CountryCurrency("AWG", "ƒ"));
        tempCountriesCurrencies.put("AX", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("AZ", new CountryCurrency("AZN", "₼"));
        tempCountriesCurrencies.put("BA", new CountryCurrency("BAM", "KM"));
        tempCountriesCurrencies.put("BB", new CountryCurrency("BBD", "$"));
        tempCountriesCurrencies.put("BD", new CountryCurrency("BDT", "৳"));
        tempCountriesCurrencies.put("BE", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("BF", new CountryCurrency("XOF", "CFA"));
        tempCountriesCurrencies.put("BG", new CountryCurrency("BGN", "лв"));
        tempCountriesCurrencies.put("BH", new CountryCurrency("BHD", ".د.ب"));
        tempCountriesCurrencies.put("BI", new CountryCurrency("BIF", "FBu"));
        tempCountriesCurrencies.put("BJ", new CountryCurrency("XOF", "CFA"));
        tempCountriesCurrencies.put("BL", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("BM", new CountryCurrency("BMD", "$"));
        tempCountriesCurrencies.put("BN", new CountryCurrency("BND", "$"));
        tempCountriesCurrencies.put("BO", new CountryCurrency("BOB", "$b"));
        tempCountriesCurrencies.put("BQ", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("BR", new CountryCurrency("BRL", "R$"));
        tempCountriesCurrencies.put("BS", new CountryCurrency("BSD", "$"));
        tempCountriesCurrencies.put("BT", new CountryCurrency("BTN", "Nu."));
        tempCountriesCurrencies.put("BV", new CountryCurrency("NOK", "kr"));
        tempCountriesCurrencies.put("BW", new CountryCurrency("BWP", "P"));
        tempCountriesCurrencies.put("BY", new CountryCurrency("BYR", "Br"));
        tempCountriesCurrencies.put("BZ", new CountryCurrency("BZD", "BZ$"));
        tempCountriesCurrencies.put("CA", new CountryCurrency("CAD", "$"));
        tempCountriesCurrencies.put("CC", new CountryCurrency("AUD", "$"));
        tempCountriesCurrencies.put("CD", new CountryCurrency("CDF", "FC"));
        tempCountriesCurrencies.put("CF", new CountryCurrency("XAF", "FCFA"));
        tempCountriesCurrencies.put("CG", new CountryCurrency("XAF", "FCFA"));
        tempCountriesCurrencies.put("CH", new CountryCurrency("CHF", "CHF"));
        tempCountriesCurrencies.put("CI", new CountryCurrency("XOF", "CFA"));
        tempCountriesCurrencies.put("CK", new CountryCurrency("NZD", "$"));
        tempCountriesCurrencies.put("CL", new CountryCurrency("CLP", "$"));
        tempCountriesCurrencies.put("CM", new CountryCurrency("XAF", "FCFA"));
        tempCountriesCurrencies.put("CN", new CountryCurrency("CNY", "¥"));
        tempCountriesCurrencies.put("CO", new CountryCurrency("COP", "$"));
        tempCountriesCurrencies.put("CR", new CountryCurrency("CRC", "₡"));
        tempCountriesCurrencies.put("CU", new CountryCurrency("CUP", "₱"));
        tempCountriesCurrencies.put("CV", new CountryCurrency("CVE", "$"));
        tempCountriesCurrencies.put("CW", new CountryCurrency("ANG", "ƒ"));
        tempCountriesCurrencies.put("CX", new CountryCurrency("AUD", "$"));
        tempCountriesCurrencies.put("CY", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("CZ", new CountryCurrency("CZK", "Kč"));
        tempCountriesCurrencies.put("DE", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("DJ", new CountryCurrency("DJF", "Fdj"));
        tempCountriesCurrencies.put("DK", new CountryCurrency("DKK", "kr"));
        tempCountriesCurrencies.put("DM", new CountryCurrency("XCD", "$"));
        tempCountriesCurrencies.put("DO", new CountryCurrency("DOP", "RD$"));
        tempCountriesCurrencies.put("DZ", new CountryCurrency("DZD", "دج"));
        tempCountriesCurrencies.put("EC", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("EE", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("EG", new CountryCurrency("EGP", "£"));
        tempCountriesCurrencies.put("EH", new CountryCurrency("MAD", "MAD"));
        tempCountriesCurrencies.put("ER", new CountryCurrency("ERN", "Nfk"));
        tempCountriesCurrencies.put("ES", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("ET", new CountryCurrency("ETB", "Br"));
        tempCountriesCurrencies.put("FI", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("FJ", new CountryCurrency("FJD", "$"));
        tempCountriesCurrencies.put("FK", new CountryCurrency("FKP", "£"));
        tempCountriesCurrencies.put("FM", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("FO", new CountryCurrency("DKK", "kr"));
        tempCountriesCurrencies.put("FR", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("GA", new CountryCurrency("XAF", "FCFA"));
        tempCountriesCurrencies.put("GB", new CountryCurrency("GBP", "£"));
        tempCountriesCurrencies.put("GD", new CountryCurrency("XCD", "$"));
        tempCountriesCurrencies.put("GE", new CountryCurrency("GEL", "ლ"));
        tempCountriesCurrencies.put("GF", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("GG", new CountryCurrency("GBP", "£"));
        tempCountriesCurrencies.put("GH", new CountryCurrency("GHS", "GH₵"));
        tempCountriesCurrencies.put("GI", new CountryCurrency("GIP", "£"));
        tempCountriesCurrencies.put("GL", new CountryCurrency("DKK", "kr"));
        tempCountriesCurrencies.put("GM", new CountryCurrency("GMD", "D"));
        tempCountriesCurrencies.put("GN", new CountryCurrency("GNF", "FG"));
        tempCountriesCurrencies.put("GP", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("GQ", new CountryCurrency("XAF", "FCFA"));
        tempCountriesCurrencies.put("GR", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("GS", new CountryCurrency("GBP", "£"));
        tempCountriesCurrencies.put("GT", new CountryCurrency("GTQ", "Q"));
        tempCountriesCurrencies.put("GU", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("GW", new CountryCurrency("XOF", "CFA"));
        tempCountriesCurrencies.put("GY", new CountryCurrency("GYD", "$"));
        tempCountriesCurrencies.put("HK", new CountryCurrency("HKD", "$"));
        tempCountriesCurrencies.put("HM", new CountryCurrency("AUD", "$"));
        tempCountriesCurrencies.put("HN", new CountryCurrency("HNL", "L"));
        tempCountriesCurrencies.put("HR", new CountryCurrency("HRK", "kn"));
        tempCountriesCurrencies.put("HT", new CountryCurrency("HTG", "G"));
        tempCountriesCurrencies.put("HU", new CountryCurrency("HUF", "Ft"));
        tempCountriesCurrencies.put("ID", new CountryCurrency("IDR", "Rp"));
        tempCountriesCurrencies.put("IE", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("IL", new CountryCurrency("ILS", "₪"));
        tempCountriesCurrencies.put("IM", new CountryCurrency("GBP", "£"));
        tempCountriesCurrencies.put("IN", new CountryCurrency("INR", "₹"));
        tempCountriesCurrencies.put("IO", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("IQ", new CountryCurrency("IQD", "ع.د"));
        tempCountriesCurrencies.put("IR", new CountryCurrency("IRR", "﷼"));
        tempCountriesCurrencies.put("IS", new CountryCurrency("ISK", "kr"));
        tempCountriesCurrencies.put("IT", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("JE", new CountryCurrency("GBP", "£"));
        tempCountriesCurrencies.put("JM", new CountryCurrency("JMD", "J$"));
        tempCountriesCurrencies.put("JO", new CountryCurrency("JOD", "JD"));
        tempCountriesCurrencies.put("JP", new CountryCurrency("JPY", "¥"));
        tempCountriesCurrencies.put("KE", new CountryCurrency("KES", "KSh"));
        tempCountriesCurrencies.put("KG", new CountryCurrency("KGS", "лв"));
        tempCountriesCurrencies.put("KH", new CountryCurrency("KHR", "៛"));
        tempCountriesCurrencies.put("KI", new CountryCurrency("AUD", "$"));
        tempCountriesCurrencies.put("KM", new CountryCurrency("KMF", "CF"));
        tempCountriesCurrencies.put("KN", new CountryCurrency("XCD", "$"));
        tempCountriesCurrencies.put("KP", new CountryCurrency("KPW", "₩"));
        tempCountriesCurrencies.put("KR", new CountryCurrency("KRW", "₩"));
        tempCountriesCurrencies.put("KW", new CountryCurrency("KWD", "KD"));
        tempCountriesCurrencies.put("KY", new CountryCurrency("KYD", "$"));
        tempCountriesCurrencies.put("KZ", new CountryCurrency("KZT", "₸"));
        tempCountriesCurrencies.put("LA", new CountryCurrency("LAK", "₭"));
        tempCountriesCurrencies.put("LB", new CountryCurrency("LBP", "£"));
        tempCountriesCurrencies.put("LC", new CountryCurrency("XCD", "$"));
        tempCountriesCurrencies.put("LI", new CountryCurrency("CHF", "CHF"));
        tempCountriesCurrencies.put("LK", new CountryCurrency("LKR", "₨"));
        tempCountriesCurrencies.put("LR", new CountryCurrency("LRD", "$"));
        tempCountriesCurrencies.put("LS", new CountryCurrency("LSL", "M"));
        tempCountriesCurrencies.put("LT", new CountryCurrency("LTL", "Lt"));
        tempCountriesCurrencies.put("LU", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("LV", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("LY", new CountryCurrency("LYD", "LD"));
        tempCountriesCurrencies.put("MA", new CountryCurrency("MAD", "MAD"));
        tempCountriesCurrencies.put("MC", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("MD", new CountryCurrency("MDL", "lei"));
        tempCountriesCurrencies.put("ME", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("MF", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("MG", new CountryCurrency("MGA", "Ar"));
        tempCountriesCurrencies.put("MH", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("MK", new CountryCurrency("MKD", "ден"));
        tempCountriesCurrencies.put("ML", new CountryCurrency("XOF", "CFA"));
        tempCountriesCurrencies.put("MM", new CountryCurrency("MMK", "K"));
        tempCountriesCurrencies.put("MN", new CountryCurrency("MNT", "₮"));
        tempCountriesCurrencies.put("MO", new CountryCurrency("MOP", "MOP$"));
        tempCountriesCurrencies.put("MP", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("MQ", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("MR", new CountryCurrency("MRO", "UM"));
        tempCountriesCurrencies.put("MS", new CountryCurrency("XCD", "$"));
        tempCountriesCurrencies.put("MT", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("MU", new CountryCurrency("MUR", "₨"));
        tempCountriesCurrencies.put("MV", new CountryCurrency("MVR", "Rf"));
        tempCountriesCurrencies.put("MW", new CountryCurrency("MWK", "MK"));
        tempCountriesCurrencies.put("MX", new CountryCurrency("MXN", "$"));
        tempCountriesCurrencies.put("MY", new CountryCurrency("MYR", "RM"));
        tempCountriesCurrencies.put("MZ", new CountryCurrency("MZN", "MT"));
        tempCountriesCurrencies.put("NA", new CountryCurrency("NAD", "N$"));
        tempCountriesCurrencies.put("NC", new CountryCurrency("XPF", "₣"));
        tempCountriesCurrencies.put("NE", new CountryCurrency("XOF", "CFA"));
        tempCountriesCurrencies.put("NF", new CountryCurrency("AUD", "$"));
        tempCountriesCurrencies.put("NG", new CountryCurrency("NGN", "₦"));
        tempCountriesCurrencies.put("NI", new CountryCurrency("NIO", "C$"));
        tempCountriesCurrencies.put("NL", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("NO", new CountryCurrency("NOK", "kr"));
        tempCountriesCurrencies.put("NP", new CountryCurrency("NPR", "₨"));
        tempCountriesCurrencies.put("NR", new CountryCurrency("AUD", "$"));
        tempCountriesCurrencies.put("NU", new CountryCurrency("NZD", "$"));
        tempCountriesCurrencies.put("NZ", new CountryCurrency("NZD", "$"));
        tempCountriesCurrencies.put("OM", new CountryCurrency("OMR", "﷼"));
        tempCountriesCurrencies.put("PA", new CountryCurrency("PAB", "B/."));
        tempCountriesCurrencies.put("PE", new CountryCurrency("PEN", "S/"));
        tempCountriesCurrencies.put("PF", new CountryCurrency("XPF", "₣"));
        tempCountriesCurrencies.put("PG", new CountryCurrency("PGK", "K"));
        tempCountriesCurrencies.put("PH", new CountryCurrency("PHP", "₱"));
        tempCountriesCurrencies.put("PK", new CountryCurrency("PKR", "₨"));
        tempCountriesCurrencies.put("PL", new CountryCurrency("PLN", "zł"));
        tempCountriesCurrencies.put("PM", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("PN", new CountryCurrency("NZD", "$"));
        tempCountriesCurrencies.put("PR", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("PS", new CountryCurrency("ILS", "₪"));
        tempCountriesCurrencies.put("PT", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("PW", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("PY", new CountryCurrency("PYG", "₲"));
        tempCountriesCurrencies.put("QA", new CountryCurrency("QAR", "﷼"));
        tempCountriesCurrencies.put("RE", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("RO", new CountryCurrency("RON", "lei"));
        tempCountriesCurrencies.put("RS", new CountryCurrency("RSD", "Дин."));
        tempCountriesCurrencies.put("RU", new CountryCurrency("RUB", "₽"));
        tempCountriesCurrencies.put("RW", new CountryCurrency("RWF", "FRw"));
        tempCountriesCurrencies.put("SA", new CountryCurrency("SAR", "﷼"));
        tempCountriesCurrencies.put("SB", new CountryCurrency("SBD", "$"));
        tempCountriesCurrencies.put("SC", new CountryCurrency("SCR", "₨"));
        tempCountriesCurrencies.put("SD", new CountryCurrency("SDG", "ج.س."));
        tempCountriesCurrencies.put("SE", new CountryCurrency("SEK", "kr"));
        tempCountriesCurrencies.put("SG", new CountryCurrency("SGD", "$"));
        tempCountriesCurrencies.put("SH", new CountryCurrency("SHP", "£"));
        tempCountriesCurrencies.put("SI", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("SJ", new CountryCurrency("NOK", "kr"));
        tempCountriesCurrencies.put("SK", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("SL", new CountryCurrency("SLL", "Le"));
        tempCountriesCurrencies.put("SM", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("SN", new CountryCurrency("XOF", "CFA"));
        tempCountriesCurrencies.put("SO", new CountryCurrency("SOS", "S"));
        tempCountriesCurrencies.put("SR", new CountryCurrency("SRD", "$"));
        tempCountriesCurrencies.put("SS", new CountryCurrency("SSP", "£"));
        tempCountriesCurrencies.put("ST", new CountryCurrency("STD", "Db"));
        tempCountriesCurrencies.put("SV", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("SX", new CountryCurrency("ANG", "ƒ"));
        tempCountriesCurrencies.put("SY", new CountryCurrency("SYP", "£"));
        tempCountriesCurrencies.put("SZ", new CountryCurrency("SZL", "L"));
        tempCountriesCurrencies.put("TC", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("TD", new CountryCurrency("XAF", "FCFA"));
        tempCountriesCurrencies.put("TF", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("TG", new CountryCurrency("XOF", "CFA"));
        tempCountriesCurrencies.put("TH", new CountryCurrency("THB", "฿"));
        tempCountriesCurrencies.put("TJ", new CountryCurrency("TJS", "SM"));
        tempCountriesCurrencies.put("TK", new CountryCurrency("NZD", "$"));
        tempCountriesCurrencies.put("TL", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("TM", new CountryCurrency("TMT", "T"));
        tempCountriesCurrencies.put("TN", new CountryCurrency("TND", "د.ت"));
        tempCountriesCurrencies.put("TO", new CountryCurrency("TOP", "T$"));
        tempCountriesCurrencies.put("TR", new CountryCurrency("TRY", "₺"));
        tempCountriesCurrencies.put("TT", new CountryCurrency("TTD", "TT$"));
        tempCountriesCurrencies.put("TV", new CountryCurrency("AUD", "$"));
        tempCountriesCurrencies.put("TW", new CountryCurrency("TWD", "NT$"));
        tempCountriesCurrencies.put("TZ", new CountryCurrency("TZS", "TSh"));
        tempCountriesCurrencies.put("UA", new CountryCurrency("UAH", "₴"));
        tempCountriesCurrencies.put("UG", new CountryCurrency("UGX", "USh"));
        tempCountriesCurrencies.put("UM", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("US", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("UY", new CountryCurrency("UYU", "$U"));
        tempCountriesCurrencies.put("UZ", new CountryCurrency("UZS", "лв"));
        tempCountriesCurrencies.put("VA", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("VC", new CountryCurrency("XCD", "$"));
        tempCountriesCurrencies.put("VE", new CountryCurrency("VEF", "Bs"));
        tempCountriesCurrencies.put("VG", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("VI", new CountryCurrency("USD", "$"));
        tempCountriesCurrencies.put("VN", new CountryCurrency("VND", "₫"));
        tempCountriesCurrencies.put("VU", new CountryCurrency("VUV", "VT"));
        tempCountriesCurrencies.put("WF", new CountryCurrency("XPF", "₣"));
        tempCountriesCurrencies.put("WS", new CountryCurrency("WST", "WS$"));
        tempCountriesCurrencies.put("XK", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("YE", new CountryCurrency("YER", "﷼"));
        tempCountriesCurrencies.put("YT", new CountryCurrency("EUR", "€"));
        tempCountriesCurrencies.put("ZA", new CountryCurrency("ZAR", "R"));
        tempCountriesCurrencies.put("ZM", new CountryCurrency("ZMW", "ZK"));
        tempCountriesCurrencies.put("ZW", new CountryCurrency("ZWL", "Z$"));

        countriesCurrencies = Collections.unmodifiableMap(tempCountriesCurrencies);
    }

    static {
        Map<String, Continent> tempContinents = new HashMap<>();

        tempContinents.put("BD", new Continent("AS", "Asia"));
        tempContinents.put("BE", new Continent("EU", "Europe"));
        tempContinents.put("BF", new Continent("AF", "Africa"));
        tempContinents.put("BG", new Continent("EU", "Europe"));
        tempContinents.put("BA", new Continent("EU", "Europe"));
        tempContinents.put("BB", new Continent("NA", "North America"));
        tempContinents.put("WF", new Continent("OC", "Oceania"));
        tempContinents.put("BL", new Continent("NA", "North America"));
        tempContinents.put("BM", new Continent("NA", "North America"));
        tempContinents.put("BN", new Continent("AS", "Asia"));
        tempContinents.put("BO", new Continent("SA", "South America"));
        tempContinents.put("BH", new Continent("AS", "Asia"));
        tempContinents.put("BI", new Continent("AF", "Africa"));
        tempContinents.put("BJ", new Continent("AF", "Africa"));
        tempContinents.put("BT", new Continent("AS", "Asia"));
        tempContinents.put("JM", new Continent("NA", "North America"));
        tempContinents.put("BV", new Continent("AN", "Antarctica"));
        tempContinents.put("BW", new Continent("AF", "Africa"));
        tempContinents.put("WS", new Continent("OC", "Oceania"));
        tempContinents.put("BQ", new Continent("NA", "North America"));
        tempContinents.put("BR", new Continent("SA", "South America"));
        tempContinents.put("BS", new Continent("NA", "North America"));
        tempContinents.put("JE", new Continent("EU", "Europe"));
        tempContinents.put("BY", new Continent("EU", "Europe"));
        tempContinents.put("BZ", new Continent("NA", "North America"));
        tempContinents.put("RU", new Continent("EU", "Europe"));
        tempContinents.put("RW", new Continent("AF", "Africa"));
        tempContinents.put("RS", new Continent("EU", "Europe"));
        tempContinents.put("TL", new Continent("OC", "Oceania"));
        tempContinents.put("RE", new Continent("AF", "Africa"));
        tempContinents.put("TM", new Continent("AS", "Asia"));
        tempContinents.put("TJ", new Continent("AS", "Asia"));
        tempContinents.put("RO", new Continent("EU", "Europe"));
        tempContinents.put("TK", new Continent("OC", "Oceania"));
        tempContinents.put("GW", new Continent("AF", "Africa"));
        tempContinents.put("GU", new Continent("OC", "Oceania"));
        tempContinents.put("GT", new Continent("NA", "North America"));
        tempContinents.put("GS", new Continent("AN", "Antarctica"));
        tempContinents.put("GR", new Continent("EU", "Europe"));
        tempContinents.put("GQ", new Continent("AF", "Africa"));
        tempContinents.put("GP", new Continent("NA", "North America"));
        tempContinents.put("JP", new Continent("AS", "Asia"));
        tempContinents.put("GY", new Continent("SA", "South America"));
        tempContinents.put("GG", new Continent("EU", "Europe"));
        tempContinents.put("GF", new Continent("SA", "South America"));
        tempContinents.put("GE", new Continent("AS", "Asia"));
        tempContinents.put("GD", new Continent("NA", "North America"));
        tempContinents.put("GB", new Continent("EU", "Europe"));
        tempContinents.put("GA", new Continent("AF", "Africa"));
        tempContinents.put("SV", new Continent("NA", "North America"));
        tempContinents.put("GN", new Continent("AF", "Africa"));
        tempContinents.put("GM", new Continent("AF", "Africa"));
        tempContinents.put("GL", new Continent("NA", "North America"));
        tempContinents.put("GI", new Continent("EU", "Europe"));
        tempContinents.put("GH", new Continent("AF", "Africa"));
        tempContinents.put("OM", new Continent("AS", "Asia"));
        tempContinents.put("TN", new Continent("AF", "Africa"));
        tempContinents.put("JO", new Continent("AS", "Asia"));
        tempContinents.put("HR", new Continent("EU", "Europe"));
        tempContinents.put("HT", new Continent("NA", "North America"));
        tempContinents.put("HU", new Continent("EU", "Europe"));
        tempContinents.put("HK", new Continent("AS", "Asia"));
        tempContinents.put("HN", new Continent("NA", "North America"));
        tempContinents.put("HM", new Continent("AN", "Antarctica"));
        tempContinents.put("VE", new Continent("SA", "South America"));
        tempContinents.put("PR", new Continent("NA", "North America"));
        tempContinents.put("PS", new Continent("AS", "Asia"));
        tempContinents.put("PW", new Continent("OC", "Oceania"));
        tempContinents.put("PT", new Continent("EU", "Europe"));
        tempContinents.put("SJ", new Continent("EU", "Europe"));
        tempContinents.put("PY", new Continent("SA", "South America"));
        tempContinents.put("IQ", new Continent("AS", "Asia"));
        tempContinents.put("PA", new Continent("NA", "North America"));
        tempContinents.put("PF", new Continent("OC", "Oceania"));
        tempContinents.put("PG", new Continent("OC", "Oceania"));
        tempContinents.put("PE", new Continent("SA", "South America"));
        tempContinents.put("PK", new Continent("AS", "Asia"));
        tempContinents.put("PH", new Continent("AS", "Asia"));
        tempContinents.put("PN", new Continent("OC", "Oceania"));
        tempContinents.put("PL", new Continent("EU", "Europe"));
        tempContinents.put("PM", new Continent("NA", "North America"));
        tempContinents.put("ZM", new Continent("AF", "Africa"));
        tempContinents.put("EH", new Continent("AF", "Africa"));
        tempContinents.put("EE", new Continent("EU", "Europe"));
        tempContinents.put("EG", new Continent("AF", "Africa"));
        tempContinents.put("ZA", new Continent("AF", "Africa"));
        tempContinents.put("EC", new Continent("SA", "South America"));
        tempContinents.put("IT", new Continent("EU", "Europe"));
        tempContinents.put("VN", new Continent("AS", "Asia"));
        tempContinents.put("SB", new Continent("OC", "Oceania"));
        tempContinents.put("ET", new Continent("AF", "Africa"));
        tempContinents.put("SO", new Continent("AF", "Africa"));
        tempContinents.put("ZW", new Continent("AF", "Africa"));
        tempContinents.put("SA", new Continent("AS", "Asia"));
        tempContinents.put("ES", new Continent("EU", "Europe"));
        tempContinents.put("ER", new Continent("AF", "Africa"));
        tempContinents.put("ME", new Continent("EU", "Europe"));
        tempContinents.put("MD", new Continent("EU", "Europe"));
        tempContinents.put("MG", new Continent("AF", "Africa"));
        tempContinents.put("MF", new Continent("NA", "North America"));
        tempContinents.put("MA", new Continent("AF", "Africa"));
        tempContinents.put("MC", new Continent("EU", "Europe"));
        tempContinents.put("UZ", new Continent("AS", "Asia"));
        tempContinents.put("MM", new Continent("AS", "Asia"));
        tempContinents.put("ML", new Continent("AF", "Africa"));
        tempContinents.put("MO", new Continent("AS", "Asia"));
        tempContinents.put("MN", new Continent("AS", "Asia"));
        tempContinents.put("MH", new Continent("OC", "Oceania"));
        tempContinents.put("MK", new Continent("EU", "Europe"));
        tempContinents.put("MU", new Continent("AF", "Africa"));
        tempContinents.put("MT", new Continent("EU", "Europe"));
        tempContinents.put("MW", new Continent("AF", "Africa"));
        tempContinents.put("MV", new Continent("AS", "Asia"));
        tempContinents.put("MQ", new Continent("NA", "North America"));
        tempContinents.put("MP", new Continent("OC", "Oceania"));
        tempContinents.put("MS", new Continent("NA", "North America"));
        tempContinents.put("MR", new Continent("AF", "Africa"));
        tempContinents.put("IM", new Continent("EU", "Europe"));
        tempContinents.put("UG", new Continent("AF", "Africa"));
        tempContinents.put("TZ", new Continent("AF", "Africa"));
        tempContinents.put("MY", new Continent("AS", "Asia"));
        tempContinents.put("MX", new Continent("NA", "North America"));
        tempContinents.put("IL", new Continent("AS", "Asia"));
        tempContinents.put("FR", new Continent("EU", "Europe"));
        tempContinents.put("IO", new Continent("AS", "Asia"));
        tempContinents.put("SH", new Continent("AF", "Africa"));
        tempContinents.put("FI", new Continent("EU", "Europe"));
        tempContinents.put("FJ", new Continent("OC", "Oceania"));
        tempContinents.put("FK", new Continent("SA", "South America"));
        tempContinents.put("FM", new Continent("OC", "Oceania"));
        tempContinents.put("FO", new Continent("EU", "Europe"));
        tempContinents.put("NI", new Continent("NA", "North America"));
        tempContinents.put("NL", new Continent("EU", "Europe"));
        tempContinents.put("NO", new Continent("EU", "Europe"));
        tempContinents.put("NA", new Continent("AF", "Africa"));
        tempContinents.put("VU", new Continent("OC", "Oceania"));
        tempContinents.put("NC", new Continent("OC", "Oceania"));
        tempContinents.put("NE", new Continent("AF", "Africa"));
        tempContinents.put("NF", new Continent("OC", "Oceania"));
        tempContinents.put("NG", new Continent("AF", "Africa"));
        tempContinents.put("NZ", new Continent("OC", "Oceania"));
        tempContinents.put("NP", new Continent("AS", "Asia"));
        tempContinents.put("NR", new Continent("OC", "Oceania"));
        tempContinents.put("NU", new Continent("OC", "Oceania"));
        tempContinents.put("CK", new Continent("OC", "Oceania"));
        tempContinents.put("XK", new Continent("EU", "Europe"));
        tempContinents.put("CI", new Continent("AF", "Africa"));
        tempContinents.put("CH", new Continent("EU", "Europe"));
        tempContinents.put("CO", new Continent("SA", "South America"));
        tempContinents.put("CN", new Continent("AS", "Asia"));
        tempContinents.put("CM", new Continent("AF", "Africa"));
        tempContinents.put("CL", new Continent("SA", "South America"));
        tempContinents.put("CC", new Continent("AS", "Asia"));
        tempContinents.put("CA", new Continent("NA", "North America"));
        tempContinents.put("CG", new Continent("AF", "Africa"));
        tempContinents.put("CF", new Continent("AF", "Africa"));
        tempContinents.put("CD", new Continent("AF", "Africa"));
        tempContinents.put("CZ", new Continent("EU", "Europe"));
        tempContinents.put("CY", new Continent("EU", "Europe"));
        tempContinents.put("CX", new Continent("AS", "Asia"));
        tempContinents.put("CR", new Continent("NA", "North America"));
        tempContinents.put("CW", new Continent("NA", "North America"));
        tempContinents.put("CV", new Continent("AF", "Africa"));
        tempContinents.put("CU", new Continent("NA", "North America"));
        tempContinents.put("SZ", new Continent("AF", "Africa"));
        tempContinents.put("SY", new Continent("AS", "Asia"));
        tempContinents.put("SX", new Continent("NA", "North America"));
        tempContinents.put("KG", new Continent("AS", "Asia"));
        tempContinents.put("KE", new Continent("AF", "Africa"));
        tempContinents.put("SS", new Continent("AF", "Africa"));
        tempContinents.put("SR", new Continent("SA", "South America"));
        tempContinents.put("KI", new Continent("OC", "Oceania"));
        tempContinents.put("KH", new Continent("AS", "Asia"));
        tempContinents.put("KN", new Continent("NA", "North America"));
        tempContinents.put("KM", new Continent("AF", "Africa"));
        tempContinents.put("ST", new Continent("AF", "Africa"));
        tempContinents.put("SK", new Continent("EU", "Europe"));
        tempContinents.put("KR", new Continent("AS", "Asia"));
        tempContinents.put("SI", new Continent("EU", "Europe"));
        tempContinents.put("KP", new Continent("AS", "Asia"));
        tempContinents.put("KW", new Continent("AS", "Asia"));
        tempContinents.put("SN", new Continent("AF", "Africa"));
        tempContinents.put("SM", new Continent("EU", "Europe"));
        tempContinents.put("SL", new Continent("AF", "Africa"));
        tempContinents.put("SC", new Continent("AF", "Africa"));
        tempContinents.put("KZ", new Continent("AS", "Asia"));
        tempContinents.put("KY", new Continent("NA", "North America"));
        tempContinents.put("SG", new Continent("AS", "Asia"));
        tempContinents.put("SE", new Continent("EU", "Europe"));
        tempContinents.put("SD", new Continent("AF", "Africa"));
        tempContinents.put("DO", new Continent("NA", "North America"));
        tempContinents.put("DM", new Continent("NA", "North America"));
        tempContinents.put("DJ", new Continent("AF", "Africa"));
        tempContinents.put("DK", new Continent("EU", "Europe"));
        tempContinents.put("VG", new Continent("NA", "North America"));
        tempContinents.put("DE", new Continent("EU", "Europe"));
        tempContinents.put("YE", new Continent("AS", "Asia"));
        tempContinents.put("DZ", new Continent("AF", "Africa"));
        tempContinents.put("US", new Continent("NA", "North America"));
        tempContinents.put("UY", new Continent("SA", "South America"));
        tempContinents.put("YT", new Continent("AF", "Africa"));
        tempContinents.put("UM", new Continent("OC", "Oceania"));
        tempContinents.put("LB", new Continent("AS", "Asia"));
        tempContinents.put("LC", new Continent("NA", "North America"));
        tempContinents.put("LA", new Continent("AS", "Asia"));
        tempContinents.put("TV", new Continent("OC", "Oceania"));
        tempContinents.put("TW", new Continent("AS", "Asia"));
        tempContinents.put("TT", new Continent("NA", "North America"));
        tempContinents.put("TR", new Continent("AS", "Asia"));
        tempContinents.put("LK", new Continent("AS", "Asia"));
        tempContinents.put("LI", new Continent("EU", "Europe"));
        tempContinents.put("LV", new Continent("EU", "Europe"));
        tempContinents.put("TO", new Continent("OC", "Oceania"));
        tempContinents.put("LT", new Continent("EU", "Europe"));
        tempContinents.put("LU", new Continent("EU", "Europe"));
        tempContinents.put("LR", new Continent("AF", "Africa"));
        tempContinents.put("LS", new Continent("AF", "Africa"));
        tempContinents.put("TH", new Continent("AS", "Asia"));
        tempContinents.put("TF", new Continent("AN", "Antarctica"));
        tempContinents.put("TG", new Continent("AF", "Africa"));
        tempContinents.put("TD", new Continent("AF", "Africa"));
        tempContinents.put("TC", new Continent("NA", "North America"));
        tempContinents.put("LY", new Continent("AF", "Africa"));
        tempContinents.put("VA", new Continent("EU", "Europe"));
        tempContinents.put("VC", new Continent("NA", "North America"));
        tempContinents.put("AE", new Continent("AS", "Asia"));
        tempContinents.put("AD", new Continent("EU", "Europe"));
        tempContinents.put("AG", new Continent("NA", "North America"));
        tempContinents.put("AF", new Continent("AS", "Asia"));
        tempContinents.put("AI", new Continent("NA", "North America"));
        tempContinents.put("VI", new Continent("NA", "North America"));
        tempContinents.put("IS", new Continent("EU", "Europe"));
        tempContinents.put("IR", new Continent("AS", "Asia"));
        tempContinents.put("AM", new Continent("AS", "Asia"));
        tempContinents.put("AL", new Continent("EU", "Europe"));
        tempContinents.put("AO", new Continent("AF", "Africa"));
        tempContinents.put("AQ", new Continent("AN", "Antarctica"));
        tempContinents.put("AS", new Continent("OC", "Oceania"));
        tempContinents.put("AR", new Continent("SA", "South America"));
        tempContinents.put("AU", new Continent("OC", "Oceania"));
        tempContinents.put("AT", new Continent("EU", "Europe"));
        tempContinents.put("AW", new Continent("NA", "North America"));
        tempContinents.put("IN", new Continent("AS", "Asia"));
        tempContinents.put("AX", new Continent("EU", "Europe"));
        tempContinents.put("AZ", new Continent("AS", "Asia"));
        tempContinents.put("IE", new Continent("EU", "Europe"));
        tempContinents.put("ID", new Continent("AS", "Asia"));
        tempContinents.put("UA", new Continent("EU", "Europe"));
        tempContinents.put("QA", new Continent("AS", "Asia"));
        tempContinents.put("MZ", new Continent("AF", "Africa"));

        continents = Collections.unmodifiableMap(tempContinents);
    }

     public String getCountryName(String countryCode) {
        return countryMap.get(countryCode);
    }

    public CountryFlag getCountryFlag(String countryCode) {
        return countriesFlags.get(countryCode);
    }

    public String getCountryFlagURL(String countryCode) {
        return Context.CountryFlagURL + countryCode + ".svg";
    }

    public CountryCurrency getCountryCurrency(String countryCode) {
        return countriesCurrencies.get(countryCode);
    }

    public Continent getContinent(String countryCode) {
        return continents.get(countryCode);
    }

    public boolean isEU(String countryCode) {
        return euCountries.contains(countryCode);
    }
}
