/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api.model;

import io.ipinfo.api.context.Context;
import io.ipinfo.api.model.ASN;
import io.ipinfo.api.model.Abuse;
import io.ipinfo.api.model.Carrier;
import io.ipinfo.api.model.Company;
import io.ipinfo.api.model.Continent;
import io.ipinfo.api.model.CountryCurrency;
import io.ipinfo.api.model.CountryFlag;
import io.ipinfo.api.model.Domains;
import io.ipinfo.api.model.Privacy;

public class IPResponse {
    private final String ip;
    private final String hostname;
    private final boolean bogon;
    private final boolean anycast;
    private final boolean is_anycast;
    private final String city;
    private final String region;
    private final String country;
    private final String loc;
    private final String org;
    private final String postal;
    private final String timezone;
    private final ASN asn;
    private final Company company;
    private final Carrier carrier;
    private final Privacy privacy;
    private final Abuse abuse;
    private final Domains domains;
    private transient Context context;

    public IPResponse(String ip, String hostname, boolean bogon, boolean anycast, boolean is_anycast, String city, String region, String country, String loc, String org, String postal, String timezone, ASN asn, Company company, Carrier carrier, Privacy privacy, Abuse abuse, Domains domains) {
        this.ip = ip;
        this.hostname = hostname;
        this.bogon = bogon;
        this.anycast = anycast;
        this.is_anycast = is_anycast;
        this.city = city;
        this.region = region;
        this.country = country;
        this.loc = loc;
        this.postal = postal;
        this.timezone = timezone;
        this.org = org;
        this.asn = asn;
        this.company = company;
        this.carrier = carrier;
        this.privacy = privacy;
        this.abuse = abuse;
        this.domains = domains;
    }

    public IPResponse(String ip, boolean bogon) {
        this(ip, null, bogon, false, false, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getIp() {
        return this.ip;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean getBogon() {
        return this.bogon;
    }

    public boolean getAnycast() {
        return this.anycast || this.is_anycast;
    }

    public String getCity() {
        return this.city;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCountryCode() {
        return this.country;
    }

    public String getCountryName() {
        return this.context.getCountryName(this.getCountryCode());
    }

    public Boolean isEU() {
        return this.context.isEU(this.getCountryCode());
    }

    public CountryFlag getCountryFlag() {
        return this.context.getCountryFlag(this.getCountryCode());
    }

    public String getCountryFlagURL() {
        return this.context.getCountryFlagURL(this.getCountryCode());
    }

    public CountryCurrency getCountryCurrency() {
        return this.context.getCountryCurrency(this.getCountryCode());
    }

    public Continent getContinent() {
        return this.context.getContinent(this.getCountryCode());
    }

    public String getLocation() {
        return this.loc;
    }

    public String getLatitude() {
        try {
            return this.loc.split(",")[0];
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getLongitude() {
        try {
            return this.loc.split(",")[1];
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getOrg() {
        return this.org;
    }

    public String getPostal() {
        return this.postal;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public ASN getAsn() {
        return this.asn;
    }

    public Company getCompany() {
        return this.company;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public Abuse getAbuse() {
        return this.abuse;
    }

    public Domains getDomains() {
        return this.domains;
    }

    public String toString() {
        return this.bogon ? "IPResponse{ip='" + this.ip + '\'' + ", bogon='" + this.bogon + '\'' + "}" : "IPResponse{ip='" + this.ip + '\'' + ", hostname='" + this.hostname + '\'' + ", anycast=" + this.anycast + ", is_anycast=" + this.is_anycast + ", city='" + this.city + '\'' + ", region='" + this.region + '\'' + ", country='" + this.country + '\'' + ", loc='" + this.loc + '\'' + ", org='" + this.org + '\'' + ", postal='" + this.postal + '\'' + ", timezone='" + this.timezone + '\'' + ", asn=" + this.asn + ", company=" + this.company + ", carrier=" + this.carrier + ", privacy=" + this.privacy + ", abuse=" + this.abuse + ", domains=" + this.domains + '}';
    }
}

