/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api.request;

import io.ipinfo.api.errors.RateLimitedException;
import io.ipinfo.api.model.ASNResponse;
import io.ipinfo.api.request.BaseRequest;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ASNRequest
extends BaseRequest<ASNResponse> {
    private static final String URL_FORMAT = "https://ipinfo.io/%s";
    private final String asn;

    public ASNRequest(OkHttpClient client, String token, String asn) {
        super(client, token);
        this.asn = asn;
    }

    @Override
    public ASNResponse handle() throws RateLimitedException {
        String url = String.format(URL_FORMAT, this.asn);
        Request.Builder request = new Request.Builder().url(url).get();
        try (Response response = this.handleRequest(request);){
            if (response == null || response.body() == null) {
                ASNResponse aSNResponse = null;
                return aSNResponse;
            }
            ASNResponse aSNResponse = (ASNResponse)gson.fromJson(response.body().string(), ASNResponse.class);
            return aSNResponse;
        }
    }
}

