/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api.request;

import io.ipinfo.api.errors.ErrorResponseException;
import io.ipinfo.api.errors.RateLimitedException;
import io.ipinfo.api.model.IPResponse;
import io.ipinfo.api.request.BaseRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class IPRequest
extends BaseRequest<IPResponse> {
    private static final String URL_FORMAT = "https://ipinfo.io/%s";
    private final String ip;
    static IpAddressMatcher[] IpAddressMatcherList = new IpAddressMatcher[]{new IpAddressMatcher("0.0.0.0/8"), new IpAddressMatcher("10.0.0.0/8"), new IpAddressMatcher("100.64.0.0/10"), new IpAddressMatcher("127.0.0.0/8"), new IpAddressMatcher("169.254.0.0/16"), new IpAddressMatcher("172.16.0.0/12"), new IpAddressMatcher("192.0.0.0/24"), new IpAddressMatcher("192.0.2.0/24"), new IpAddressMatcher("192.168.0.0/16"), new IpAddressMatcher("198.18.0.0/15"), new IpAddressMatcher("198.51.100.0/24"), new IpAddressMatcher("203.0.113.0/24"), new IpAddressMatcher("224.0.0.0/4"), new IpAddressMatcher("240.0.0.0/4"), new IpAddressMatcher("255.255.255.255/32"), new IpAddressMatcher("::/128"), new IpAddressMatcher("::1/128"), new IpAddressMatcher("::ffff:0:0/96"), new IpAddressMatcher("::/96"), new IpAddressMatcher("100::/64"), new IpAddressMatcher("2001:10::/28"), new IpAddressMatcher("2001:db8::/32"), new IpAddressMatcher("fc00::/7"), new IpAddressMatcher("fe80::/10"), new IpAddressMatcher("fec0::/10"), new IpAddressMatcher("ff00::/8"), new IpAddressMatcher("2002::/24"), new IpAddressMatcher("2002:a00::/24"), new IpAddressMatcher("2002:7f00::/24"), new IpAddressMatcher("2002:a9fe::/32"), new IpAddressMatcher("2002:ac10::/28"), new IpAddressMatcher("2002:c000::/40"), new IpAddressMatcher("2002:c000:200::/40"), new IpAddressMatcher("2002:c0a8::/32"), new IpAddressMatcher("2002:c612::/31"), new IpAddressMatcher("2002:c633:6400::/40"), new IpAddressMatcher("2002:cb00:7100::/40"), new IpAddressMatcher("2002:e000::/20"), new IpAddressMatcher("2002:f000::/20"), new IpAddressMatcher("2002:ffff:ffff::/48"), new IpAddressMatcher("2001::/40"), new IpAddressMatcher("2001:0:a00::/40"), new IpAddressMatcher("2001:0:7f00::/40"), new IpAddressMatcher("2001:0:a9fe::/48"), new IpAddressMatcher("2001:0:ac10::/44"), new IpAddressMatcher("2001:0:c000::/56"), new IpAddressMatcher("2001:0:c000:200::/56"), new IpAddressMatcher("2001:0:c0a8::/48"), new IpAddressMatcher("2001:0:c612::/47"), new IpAddressMatcher("2001:0:c633:6400::/56"), new IpAddressMatcher("2001:0:cb00:7100::/56"), new IpAddressMatcher("2001:0:e000::/36"), new IpAddressMatcher("2001:0:f000::/36"), new IpAddressMatcher("2001:0:ffff:ffff::/64")};

    public IPRequest(OkHttpClient client, String token, String ip) {
        super(client, token);
        this.ip = ip;
    }

    @Override
    public IPResponse handle() throws RateLimitedException {
        if (IPRequest.isBogon(this.ip)) {
            try {
                return new IPResponse(this.ip, true);
            }
            catch (Exception ex) {
                throw new ErrorResponseException(ex);
            }
        }
        String url = String.format(URL_FORMAT, this.ip);
        Request.Builder request = new Request.Builder().url(url).get();
        try (Response response = this.handleRequest(request);){
            if (response == null || response.body() == null) {
                IPResponse iPResponse = null;
                return iPResponse;
            }
            IPResponse iPResponse = (IPResponse)gson.fromJson(response.body().string(), IPResponse.class);
            return iPResponse;
        }
    }

    static boolean isBogon(String ip) {
        for (int i = 0; i < IpAddressMatcherList.length; ++i) {
            IpAddressMatcher ipAddressMatcher = IpAddressMatcherList[i];
            if (!ipAddressMatcher.matches(ip)) continue;
            return true;
        }
        return false;
    }

    static InetAddress parseAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to parse address: " + address, e);
        }
    }

    public static class IpAddressMatcher {
        private final int nMaskBits;
        private final InetAddress requiredAddress;

        public IpAddressMatcher(String ipAddress) {
            if (ipAddress.indexOf(47) > 0) {
                String[] addressAndMask = ipAddress.split("/");
                ipAddress = addressAndMask[0];
                this.nMaskBits = Integer.parseInt(addressAndMask[1]);
            } else {
                this.nMaskBits = -1;
            }
            this.requiredAddress = IPRequest.parseAddress(ipAddress);
        }

        public boolean matches(String address) {
            InetAddress remoteAddress = IPRequest.parseAddress(address);
            if (!this.requiredAddress.getClass().equals(remoteAddress.getClass())) {
                return false;
            }
            if (this.nMaskBits < 0) {
                return remoteAddress.equals(this.requiredAddress);
            }
            byte[] remAddr = remoteAddress.getAddress();
            byte[] reqAddr = this.requiredAddress.getAddress();
            int nMaskFullBytes = this.nMaskBits / 8;
            byte finalByte = (byte)(65280 >> (this.nMaskBits & 7));
            for (int i = 0; i < nMaskFullBytes; ++i) {
                if (remAddr[i] == reqAddr[i]) continue;
                return false;
            }
            if (finalByte != 0) {
                return (remAddr[nMaskFullBytes] & finalByte) == (reqAddr[nMaskFullBytes] & finalByte);
            }
            return true;
        }
    }
}

