/*
 * Decompiled with CFR 0.152.
 */
package io.ipinfo.api.request;

import io.ipinfo.api.errors.RateLimitedException;
import io.ipinfo.api.model.MapResponse;
import io.ipinfo.api.request.BaseRequest;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MapRequest
extends BaseRequest<MapResponse> {
    private static final String URL = "https://ipinfo.io/tools/map";
    private final List<String> ips;

    public MapRequest(OkHttpClient client, String token, List<String> ips) {
        super(client, token);
        this.ips = ips;
    }

    @Override
    public MapResponse handle() throws RateLimitedException {
        String jsonIpList = gson.toJson(this.ips);
        RequestBody requestBody = RequestBody.create(null, (String)jsonIpList);
        Request.Builder request = new Request.Builder().url(URL).post(requestBody);
        try (Response response = this.handleRequest(request);){
            if (response == null || response.body() == null) {
                MapResponse mapResponse = null;
                return mapResponse;
            }
            MapResponse mapResponse = (MapResponse)gson.fromJson(response.body().string(), MapResponse.class);
            return mapResponse;
        }
    }
}

