/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.topology;

import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.topology.Requests;
import io.lettuce.core.cluster.topology.TimedAsyncCommand;
import io.lettuce.core.cluster.topology.TopologyComparators;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

class Connections {
    private final Map<RedisURI, StatefulRedisConnection<String, String>> connections;
    private volatile boolean closed = false;

    public Connections() {
        this.connections = new TreeMap<RedisURI, StatefulRedisConnection<String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);
    }

    private Connections(Map<RedisURI, StatefulRedisConnection<String, String>> connections) {
        this.connections = connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(RedisURI redisURI, StatefulRedisConnection<String, String> connection) {
        if (this.closed) {
            connection.close();
            return;
        }
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            if (this.closed) {
                connection.close();
                return;
            }
            this.connections.put(redisURI, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            return this.connections.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Requests requestTopology() {
        Requests requests = new Requests();
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            for (Map.Entry<RedisURI, StatefulRedisConnection<String, String>> entry : this.connections.entrySet()) {
                CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.NODES);
                Command command = new Command(CommandType.CLUSTER, new StatusOutput<String, String>(StringCodec.UTF8), args);
                TimedAsyncCommand<String, String, String> timedCommand = new TimedAsyncCommand<String, String, String>(command);
                entry.getValue().dispatch(timedCommand);
                requests.addRequest(entry.getKey(), timedCommand);
            }
        }
        return requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Requests requestClients() {
        Requests requests = new Requests();
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            for (Map.Entry<RedisURI, StatefulRedisConnection<String, String>> entry : this.connections.entrySet()) {
                CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.LIST);
                Command command = new Command(CommandType.CLIENT, new StatusOutput<String, String>(StringCodec.UTF8), args);
                TimedAsyncCommand<String, String, String> timedCommand = new TimedAsyncCommand<String, String, String>(command);
                entry.getValue().dispatch(timedCommand);
                requests.addRequest(entry.getKey(), timedCommand);
            }
        }
        return requests;
    }

    public void close() {
        this.closed = true;
        while (this.hasConnections()) {
            this.drainConnections().forEach(StatefulConnection::close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasConnections() {
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            return !this.connections.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<StatefulRedisConnection<String, String>> drainConnections() {
        HashMap<RedisURI, StatefulRedisConnection<String, String>> drainedConnections;
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            drainedConnections = new HashMap<RedisURI, StatefulRedisConnection<String, String>>(this.connections);
            drainedConnections.forEach((k, v) -> this.connections.remove(k));
        }
        return drainedConnections.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connections mergeWith(Connections discoveredConnections) {
        TreeMap<RedisURI, StatefulRedisConnection<String, String>> result = new TreeMap<RedisURI, StatefulRedisConnection<String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);
        this.closed = true;
        discoveredConnections.closed = true;
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            Map<RedisURI, StatefulRedisConnection<String, String>> map2 = discoveredConnections.connections;
            synchronized (map2) {
                result.putAll(this.connections);
                result.putAll(discoveredConnections.connections);
            }
        }
        return new Connections(result);
    }
}

