/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.KeyMethod;
import io.lindstrom.m3u8.model.SegmentKey;
import io.lindstrom.m3u8.parser.Attribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Map;

public enum SegmentKeyAttribute implements Attribute<SegmentKey, SegmentKey.Builder>
{
    METHOD{

        @Override
        public void read(SegmentKey.Builder builder, String value) {
            builder.method(KeyMethod.parse(value));
        }

        @Override
        public void write(SegmentKey segmentKey, TextBuilder textBuilder) {
            textBuilder.add(this.name(), segmentKey.method());
        }
    }
    ,
    URI{

        @Override
        public void read(SegmentKey.Builder builder, String value) {
            builder.uri(value);
        }

        @Override
        public void write(SegmentKey segmentKey, TextBuilder textBuilder) {
            segmentKey.uri().ifPresent(uri -> textBuilder.addQuoted(this.name(), (String)uri));
        }
    }
    ,
    IV{

        @Override
        public void read(SegmentKey.Builder builder, String value) {
            builder.iv(value);
        }

        @Override
        public void write(SegmentKey segmentKey, TextBuilder textBuilder) {
            segmentKey.iv().ifPresent(iv -> textBuilder.add(this.name(), (String)iv));
        }
    }
    ,
    KEYFORMAT{

        @Override
        public void read(SegmentKey.Builder builder, String value) {
            builder.keyFormat(value);
        }

        @Override
        public void write(SegmentKey segmentKey, TextBuilder textBuilder) {
            segmentKey.keyFormat().ifPresent(keyFormat -> textBuilder.addQuoted(this.name(), (String)keyFormat));
        }
    }
    ,
    KEYFORMATVERSIONS{

        @Override
        public void read(SegmentKey.Builder builder, String value) {
            builder.keyFormatVersions(value);
        }

        @Override
        public void write(SegmentKey segmentKey, TextBuilder textBuilder) {
            segmentKey.keyFormatVersions().ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    };

    static final Map<String, SegmentKeyAttribute> attributeMap;

    static SegmentKey parse(String attributes, ParsingMode parsingMode) throws PlaylistParserException {
        SegmentKey.Builder builder = SegmentKey.builder();
        ParserUtils.readAttributes(attributeMap, attributes, builder, parsingMode);
        return builder.build();
    }

    static {
        attributeMap = ParserUtils.toMap(SegmentKeyAttribute.values(), Attribute::key);
    }
}

