/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.Skip;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class SkipBuilder {
    private static final long INIT_BIT_SKIPPED_SEGMENTS = 1L;
    private long initBits = 1L;
    private long skippedSegments;
    private List<String> recentlyRemovedDateRanges = new ArrayList<String>();

    SkipBuilder() {
        if (!(this instanceof Skip.Builder)) {
            throw new UnsupportedOperationException("Use: new Skip.Builder()");
        }
    }

    public final Skip.Builder from(Skip instance) {
        Objects.requireNonNull(instance, "instance");
        this.skippedSegments(instance.skippedSegments());
        this.addAllRecentlyRemovedDateRanges(instance.recentlyRemovedDateRanges());
        return (Skip.Builder)this;
    }

    public final Skip.Builder skippedSegments(long skippedSegments) {
        this.skippedSegments = skippedSegments;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (Skip.Builder)this;
    }

    public final Skip.Builder addRecentlyRemovedDateRanges(String element) {
        this.recentlyRemovedDateRanges.add(Objects.requireNonNull(element, "recentlyRemovedDateRanges element"));
        return (Skip.Builder)this;
    }

    public final Skip.Builder addRecentlyRemovedDateRanges(String ... elements) {
        for (String element : elements) {
            this.recentlyRemovedDateRanges.add(Objects.requireNonNull(element, "recentlyRemovedDateRanges element"));
        }
        return (Skip.Builder)this;
    }

    public final Skip.Builder recentlyRemovedDateRanges(Iterable<String> elements) {
        this.recentlyRemovedDateRanges.clear();
        return this.addAllRecentlyRemovedDateRanges(elements);
    }

    public final Skip.Builder addAllRecentlyRemovedDateRanges(Iterable<String> elements) {
        for (String element : elements) {
            this.recentlyRemovedDateRanges.add(Objects.requireNonNull(element, "recentlyRemovedDateRanges element"));
        }
        return (Skip.Builder)this;
    }

    public Skip build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableSkip(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("skippedSegments");
        }
        return "Cannot build Skip, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static final class ImmutableSkip
    implements Skip {
        private final long skippedSegments;
        private final List<String> recentlyRemovedDateRanges;

        private ImmutableSkip(SkipBuilder builder) {
            this.skippedSegments = builder.skippedSegments;
            this.recentlyRemovedDateRanges = SkipBuilder.createUnmodifiableList(true, builder.recentlyRemovedDateRanges);
        }

        @Override
        public long skippedSegments() {
            return this.skippedSegments;
        }

        @Override
        public List<String> recentlyRemovedDateRanges() {
            return this.recentlyRemovedDateRanges;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableSkip && this.equalTo((ImmutableSkip)another);
        }

        private boolean equalTo(ImmutableSkip another) {
            return this.skippedSegments == another.skippedSegments && this.recentlyRemovedDateRanges.equals(another.recentlyRemovedDateRanges);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Long.hashCode(this.skippedSegments);
            h += (h << 5) + this.recentlyRemovedDateRanges.hashCode();
            return h;
        }

        public String toString() {
            return "Skip{skippedSegments=" + this.skippedSegments + ", recentlyRemovedDateRanges=" + this.recentlyRemovedDateRanges + "}";
        }
    }
}

