/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.jackson.dataformat.hal.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import io.openapitools.jackson.dataformat.hal.HALLink;
import io.openapitools.jackson.dataformat.hal.annotation.EmbeddedResource;
import io.openapitools.jackson.dataformat.hal.annotation.Link;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HALBeanSerializer
extends BeanSerializerBase {
    private static final Logger LOG = LoggerFactory.getLogger(HALBeanSerializer.class);

    public HALBeanSerializer(BeanSerializerBase src) {
        super(src);
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this;
    }

    public BeanSerializerBase withFilterId(Object o) {
        return this;
    }

    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    protected BeanSerializerBase withIgnorals(Set<String> set) {
        return this;
    }

    public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        FilteredProperties filtered = new FilteredProperties(bean, provider);
        filtered.serialize(bean, jgen, provider);
    }

    private static class LinkProperty {
        private HALLink link;
        private Collection<HALLink> links;

        public LinkProperty(HALLink link) {
            this.link = link;
        }

        public LinkProperty(Collection<HALLink> links) {
            this.links = links == null ? new HashSet() : links;
        }

        public void serialize(JsonGenerator jgen) throws IOException {
            if (this.link != null) {
                this.writeLinkObject(jgen, this.link);
            } else if (this.links != null) {
                jgen.writeStartArray();
                for (HALLink curLink : this.links) {
                    this.writeLinkObject(jgen, curLink);
                }
                jgen.writeEndArray();
            }
        }

        private void writeLinkObject(JsonGenerator jgen, HALLink link) throws IOException {
            jgen.writeObject((Object)link);
        }
    }

    private class FilteredProperties {
        private List<BeanPropertyWriter> state = new ArrayList<BeanPropertyWriter>();
        private Map<String, LinkProperty> links = new TreeMap<String, LinkProperty>();
        private Map<String, BeanPropertyWriter> embedded = new TreeMap<String, BeanPropertyWriter>();

        public FilteredProperties(Object bean, SerializerProvider provider) throws IOException {
            for (BeanPropertyWriter prop : HALBeanSerializer.this._props) {
                try {
                    if (prop.getAnnotation(EmbeddedResource.class) != null) {
                        Object object = prop.get(bean);
                        if (object == null) continue;
                        EmbeddedResource er = (EmbeddedResource)prop.getAnnotation(EmbeddedResource.class);
                        String val = "".equals(er.value()) ? prop.getName() : er.value();
                        this.addEmbeddedProperty(val, prop);
                        continue;
                    }
                    if (prop.getAnnotation(Link.class) != null) {
                        Link l = (Link)prop.getAnnotation(Link.class);
                        String relation = "".equals(l.value()) ? prop.getName() : l.value();
                        Object value = prop.get(bean);
                        if (value instanceof Collection) {
                            this.addLinks(relation, (Collection)prop.get(bean));
                            continue;
                        }
                        if (!(value instanceof HALLink)) continue;
                        this.addLink(relation, (HALLink)prop.get(bean));
                        continue;
                    }
                    this.state.add(prop);
                }
                catch (Exception e) {
                    HALBeanSerializer.this.wrapAndThrow(provider, e, bean, prop.getName());
                }
            }
        }

        public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            if (!this.links.isEmpty()) {
                jgen.writeFieldName("_links");
                jgen.writeStartObject();
                for (String rel : this.links.keySet()) {
                    jgen.writeFieldName(rel);
                    this.links.get(rel).serialize(jgen);
                }
                jgen.writeEndObject();
            }
            if (!this.embedded.isEmpty()) {
                jgen.writeFieldName("_embedded");
                jgen.writeStartObject();
                for (String rel : this.embedded.keySet()) {
                    try {
                        jgen.writeFieldName(rel);
                        jgen.writeObject(this.embedded.get(rel).get(bean));
                    }
                    catch (Exception e) {
                        HALBeanSerializer.this.wrapAndThrow(provider, e, bean, rel);
                    }
                }
                jgen.writeEndObject();
            }
            for (BeanPropertyWriter prop : this.state) {
                try {
                    prop.serializeAsField(bean, jgen, provider);
                }
                catch (Exception e) {
                    HALBeanSerializer.this.wrapAndThrow(provider, e, bean, prop.getName());
                }
            }
            jgen.writeEndObject();
        }

        private void addEmbeddedProperty(String rel, BeanPropertyWriter property) {
            if (this.embedded.put(rel, property) != null) {
                LOG.warn("Embedded resource already existed with rel [{}] in class [{}]", (Object)rel, (Object)HALBeanSerializer.this._handledType);
            }
        }

        private void addLink(String rel, HALLink link) {
            if (this.links.put(rel, new LinkProperty(link)) != null) {
                LOG.warn("Link resource already existed with rel [{}] in class [{}]", (Object)rel, (Object)HALBeanSerializer.this._handledType);
            }
        }

        private void addLinks(String rel, Collection<HALLink> links) {
            if (this.links.put(rel, new LinkProperty(links)) != null) {
                LOG.warn("Link resource already existed with rel [{}] in class [{}]", (Object)rel, (Object)HALBeanSerializer.this._handledType);
            }
        }
    }
}

