/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.buffer;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.buffer.ByteNotFoundException;
import java.io.IOException;

public abstract class BaseBuffer
implements Buffer {
    protected static final byte LF = 10;
    protected static final byte CR = 13;

    @Override
    public abstract Buffer clone();

    @Override
    public boolean hasWritableBytes() {
        return this.getWritableBytes() > 0;
    }

    protected boolean checkWritableBytesSafe(int length) {
        return this.getWritableBytes() >= length;
    }

    protected void checkReadableBytes(int length) throws IndexOutOfBoundsException {
        if (!this.checkReadableBytesSafe(length)) {
            throw new IndexOutOfBoundsException("Not enough readable bytes");
        }
    }

    protected boolean checkReadableBytesSafe(int length) {
        return this.getReadableBytes() >= length;
    }

    @Override
    public final Buffer readUntil(byte b) throws IOException, ByteNotFoundException {
        return this.readUntil(4096, b);
    }

    @Override
    public final Buffer readUntil(int maxBytes, byte ... bytes) throws IOException, ByteNotFoundException, IllegalArgumentException {
        Buffer result = this.readUntilSafe(maxBytes, bytes);
        if (result == null) {
            throw new ByteNotFoundException(bytes);
        }
        return result;
    }

    @Override
    public final Buffer readUntilSafe(int maxBytes, byte ... bytes) throws IOException, IllegalArgumentException {
        int index = this.indexOf(maxBytes, bytes);
        if (index == -1) {
            return null;
        }
        int size = index - this.getReaderIndex();
        Buffer result = null;
        result = size == 0 ? Buffers.EMPTY_BUFFER : this.readBytes(size);
        this.readByte();
        return result;
    }

    @Override
    public final int indexOf(int maxBytes, byte ... bytes) throws IOException, ByteNotFoundException, IllegalArgumentException {
        if (bytes.length == 0) {
            throw new IllegalArgumentException("No bytes specified. Not sure what you want me to look for");
        }
        int start = this.getReaderIndex();
        int index = -1;
        while (this.hasReadableBytes() && this.getReaderIndex() - start < maxBytes && index == -1) {
            if (!BaseBuffer.isByteInArray(this.readByte(), bytes)) continue;
            index = this.getReaderIndex() - 1;
        }
        this.setReaderIndex(start);
        if (this.getReaderIndex() - start >= maxBytes) {
            throw new ByteNotFoundException(maxBytes, bytes);
        }
        return index;
    }

    @Override
    public final int indexOf(byte b) throws IOException, ByteNotFoundException, IllegalArgumentException {
        return this.indexOf(4096, b);
    }

    @Override
    public final Buffer readLine() throws IOException {
        int start = this.getReaderIndex();
        boolean foundCR = false;
        block4: while (this.hasReadableBytes()) {
            byte b = this.readByte();
            switch (b) {
                case 10: {
                    return this.slice(start, this.getReaderIndex() - (foundCR ? 2 : 1));
                }
                case 13: {
                    foundCR = true;
                    continue block4;
                }
            }
            if (!foundCR) continue;
            this.setReaderIndex(this.getReaderIndex() - 1);
            return this.slice(start, this.getReaderIndex() - 1);
        }
        if (start >= this.getReaderIndex()) {
            return null;
        }
        return this.slice(start, this.getReaderIndex());
    }

    @Override
    public final Buffer readUntilSingleCRLF() throws IOException {
        int start = this.getReaderIndex();
        int found = 0;
        while (found < 2 && this.hasReadableBytes()) {
            byte b = this.readByte();
            if (found == 0 && b == 13) {
                ++found;
                continue;
            }
            if (found == 1 && b == 10) {
                ++found;
                continue;
            }
            found = 0;
        }
        if (found == 2) {
            return this.slice(start, this.getReaderIndex() - 2);
        }
        this.setReaderIndex(start);
        return null;
    }

    @Override
    public final Buffer readUntilDoubleCRLF() throws IOException {
        int start = this.getReaderIndex();
        int found = 0;
        while (found < 4 && this.hasReadableBytes()) {
            byte b = this.readByte();
            if ((found == 0 || found == 2) && b == 13) {
                ++found;
                continue;
            }
            if ((found == 1 || found == 3) && b == 10) {
                ++found;
                continue;
            }
            found = 0;
        }
        if (found == 4) {
            return this.slice(start, this.getReaderIndex() - 4);
        }
        this.setReaderIndex(start);
        return null;
    }

    @Override
    public final int parseToInt() throws NumberFormatException, IOException {
        return this.parseToInt(10);
    }

    @Override
    public final int parseToInt(int radix) throws NumberFormatException, IOException {
        if (this.getReadableBytes() == 0) {
            throw new NumberFormatException("Buffer is empty, cannot convert it to an integer");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        int result = 0;
        boolean negative = false;
        int i = this.getReaderIndex();
        int max = this.getReadableBytes() + this.getReaderIndex();
        if (max > 0) {
            int digit;
            int limit;
            if (this.getByte(i) == 45) {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit((char)this.getByte(i++), radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + this + "\"");
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit((char)this.getByte(i++), radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + this + "\"");
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + this + "\"");
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("For input string: \"" + this + "\"");
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + this + "\"");
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("For input string: \"" + this + "\"");
        }
        return -result;
    }

    protected static boolean isByteInArray(byte b, byte[] bytes) {
        for (byte x : bytes) {
            if (x != b) continue;
            return true;
        }
        return false;
    }
}

