/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.frame.PcapGlobalHeader;
import io.pkts.frame.PcapRecordHeader;
import io.pkts.framer.Framer;
import io.pkts.framer.FramerManager;
import io.pkts.framer.FramingException;
import io.pkts.packet.PCapPacket;
import io.pkts.packet.Packet;
import io.pkts.packet.impl.PCapPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.nio.ByteOrder;

public final class PcapFramer
implements Framer<Packet, PCapPacket> {
    private final PcapGlobalHeader globalHeader;
    private final FramerManager framerManager;
    private final ByteOrder byteOrder;

    public PcapFramer(PcapGlobalHeader globalHeader, FramerManager framerManager) {
        assert (globalHeader != null);
        assert (framerManager != null);
        this.globalHeader = globalHeader;
        this.byteOrder = this.globalHeader.getByteOrder();
        this.framerManager = framerManager;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.PCAP;
    }

    @Override
    public PCapPacket frame(Packet parent, Buffer buffer) throws IOException {
        Buffer record = null;
        try {
            record = buffer.readBytes(16);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        PcapRecordHeader header = new PcapRecordHeader(this.byteOrder, record);
        int length = (int)header.getCapturedLength();
        if (length < 0) {
            throw new FramingException(String.format("Invalid PCAP captured length of %d", length), Protocol.PCAP);
        }
        int total = (int)header.getTotalLength();
        Buffer payload = buffer.readBytes(Math.min(length, total));
        return new PCapPacketImpl(this.globalHeader, header, payload);
    }

    @Override
    public boolean accept(Buffer data) {
        return false;
    }
}

