/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.header.MediaTypeHeader;
import io.pkts.packet.sip.header.impl.ParametersImpl;
import java.io.IOException;

public abstract class MediaTypeHeaderImpl
extends ParametersImpl
implements MediaTypeHeader {
    private final Buffer mType;
    private final Buffer subType;

    public MediaTypeHeaderImpl(Buffer value, Buffer name, Buffer mType, Buffer subType, Buffer params) {
        super(value, name, params);
        this.mType = mType;
        this.subType = subType;
    }

    @Override
    public Buffer getContentType() {
        return this.mType;
    }

    @Override
    public Buffer getContentSubType() {
        return this.subType;
    }

    @Override
    public boolean isSDP() {
        try {
            if (this.subType.capacity() != 3 || this.mType.capacity() != 11) {
                return false;
            }
            byte a = this.subType.getByte(0);
            byte b = this.subType.getByte(1);
            byte c = this.subType.getByte(2);
            if (a != 115 && a != 83 || b != 100 && b != 68 || c != 112 && c != 80) {
                return false;
            }
            byte d = this.mType.getByte(0);
            byte e = this.mType.getByte(1);
            byte f = this.mType.getByte(2);
            byte g = this.mType.getByte(3);
            byte h = this.mType.getByte(4);
            byte i = this.mType.getByte(5);
            byte j = this.mType.getByte(6);
            byte k = this.mType.getByte(7);
            byte l = this.mType.getByte(8);
            byte m = this.mType.getByte(9);
            byte n = this.mType.getByte(10);
            return !(d != 97 && d != 65 || e != 112 && e != 80 || f != 112 && f != 80 || g != 108 && g != 76 || h != 105 && h != 73 || i != 99 && i != 67 || j != 97 && j != 65 || k != 116 && k != 84 || l != 105 && l != 73 || m != 111 && m != 79 || n != 110 && n != 78);
        }
        catch (IOException e) {
            throw new RuntimeException("Strange, IOException when accessing the subtype", e);
        }
    }

    @Override
    public MediaTypeHeader ensure() {
        return this;
    }
}

