/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import java.util.function.Function;
import reactor.netty.http.server.HttpServerConfiguration;
import reactor.netty.tcp.TcpServer;

public final class HttpRequestDecoderSpec {
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final boolean DEFAULT_VALIDATE_HEADERS = true;
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    int maxInitialLineLength = 4096;
    int maxHeaderSize = 8192;
    int maxChunkSize = 8192;
    boolean validateHeaders = true;
    int initialBufferSize = 128;

    public HttpRequestDecoderSpec maxInitialLineLength(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("maxInitialLineLength must be strictly positive");
        }
        this.maxInitialLineLength = value;
        return this;
    }

    public HttpRequestDecoderSpec maxHeaderSize(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be strictly positive");
        }
        this.maxHeaderSize = value;
        return this;
    }

    public HttpRequestDecoderSpec maxChunkSize(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("maxChunkSize must be strictly positive");
        }
        this.maxChunkSize = value;
        return this;
    }

    public HttpRequestDecoderSpec validateHeaders(boolean validate) {
        this.validateHeaders = validate;
        return this;
    }

    public HttpRequestDecoderSpec initialBufferSize(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("initialBufferSize must be strictly positive");
        }
        this.initialBufferSize = value;
        return this;
    }

    Function<TcpServer, TcpServer> build() {
        HttpRequestDecoderSpec decoder = new HttpRequestDecoderSpec();
        decoder.initialBufferSize = this.initialBufferSize;
        decoder.maxChunkSize = this.maxChunkSize;
        decoder.maxHeaderSize = this.maxHeaderSize;
        decoder.maxInitialLineLength = this.maxInitialLineLength;
        decoder.validateHeaders = this.validateHeaders;
        return tcp -> tcp.bootstrap(b -> HttpServerConfiguration.decoder(b, decoder));
    }
}

