/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Register;
import io.prometheus.client.metrics.Counter;
import io.prometheus.client.metrics.Gauge;
import io.prometheus.client.metrics.Summary;

class Telemetry {
    @Register
    static final Gauge initializeTime = Gauge.newBuilder().namespace("telemetry").name("initialization_time_ms").documentation("The time it took for the telemetry system to initialize.").build();
    @Register
    static final Gauge serverStartTime = Gauge.newBuilder().namespace("telemetry").name("server_start_time_ms").documentation("The time at which the server started.").build();
    @Register
    static final Counter telemetryRequests = Counter.newBuilder().namespace("telemetry").name("requests_metrics_total").documentation("A counter of the total requests made against the telemetry system.").build();
    @Register
    static final Summary telemetryGenerationLatencies = Summary.newBuilder().namespace("telemetry").name("generation_latency_ms").documentation("A histogram of telemetry generation latencies.").targetQuantile(0.01, 0.05).targetQuantile(0.05, 0.05).targetQuantile(0.5, 0.05).targetQuantile(0.9, 0.01).targetQuantile(0.99, 0.001).build();

    Telemetry() {
    }

    static {
        serverStartTime.newPartial().apply().set(System.currentTimeMillis() / 1000L);
    }
}

