/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit4;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.nio.file.Paths;
import java.util.Objects;
import org.junit.runner.Description;

final class AllureJunit4Utils {
    private static final Description CUCUMBER_CHECK_DESCRIPTION = Description.createSuiteDescription((String)"check", (Serializable)new CucumberCheck(), (Annotation[])new Annotation[0]);
    private static final String CUCUMBER_WORKING_DIR = Paths.get("", new String[0]).toUri().toString();
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_PREFIX = "file:";

    private AllureJunit4Utils() {
        throw new IllegalStateException("do not instance");
    }

    public static String getFullName(Description description) {
        Class testClass = description.getTestClass();
        if (Objects.isNull(testClass)) {
            UniqueIdExtract uniqueId = new UniqueIdExtract();
            Description.createSuiteDescription((String)"extract", (Serializable)uniqueId, (Annotation[])new Annotation[0]).equals((Object)description);
            String testCaseUri = uniqueId.id;
            if (Objects.nonNull(testCaseUri)) {
                if (testCaseUri.startsWith(CUCUMBER_WORKING_DIR)) {
                    return testCaseUri.substring(CUCUMBER_WORKING_DIR.length());
                }
                if (testCaseUri.startsWith(CLASSPATH_PREFIX)) {
                    return testCaseUri.substring(CLASSPATH_PREFIX.length());
                }
                if (testCaseUri.startsWith(FILE_PREFIX)) {
                    return testCaseUri.substring(FILE_PREFIX.length());
                }
                return testCaseUri;
            }
        }
        String className = description.getClassName();
        String methodName = description.getMethodName();
        return Objects.nonNull(methodName) ? String.format("%s.%s", className, methodName) : className;
    }

    public static boolean isCucumberTest(Description description) {
        return CUCUMBER_CHECK_DESCRIPTION.equals((Object)description);
    }

    static class UniqueIdExtract
    implements Serializable {
        String id;

        UniqueIdExtract() {
        }

        public boolean equals(Object obj) {
            this.id = Objects.toString(obj);
            return true;
        }

        public int hashCode() {
            return 1;
        }
    }

    static class CucumberCheck
    implements Serializable {
        CucumberCheck() {
        }

        public boolean equals(Object obj) {
            return !Objects.isNull(obj) && "io.cucumber.junit.PickleRunners.PickleId".equals(obj.getClass().getCanonicalName());
        }

        public int hashCode() {
            return 1;
        }
    }
}

